<?php $__env->startSection('contenido'); ?>

<!-- SECCIÓN Mis Compras -->
<section class="ftco-section no-gutters mb-2" id="generica">
    <div class="container-fluid">
        <?php echo $__env->make('components.profile-header', ['user'=>$user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="container-fluid">
        <div class="row pb-2">
            <div class="col-sm-12 mb-5 text-center">
                <h3 class="mt-5">Canjes de Puntos</h3>
                <hr/>
            </div>
        </div>
        <div class="row pb-2 text-center">
            <div class="col-9 col-md-9 col-xl-9 m-auto">
                <p class="text-center m-auto">Desde esta sección puede ver todas las experiencias recibidas por el canje de puntos desde LatamPass, Banco Patagonia, y más.</p>
                <p class="text-center m-auto">Para utilizar estas experiencias, <strong>comunicate con el anfitrión, y llevale el código de la experiencia,</strong> para coordinar día y horario.</p>
            </div>
        </div>
        <br>
        <div class="row pb-2">
            <div class="col-md-12 mb-5 ">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                    <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                        <thead class="thead-dark">
                                        <tr>
                                            <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                            <th class="encabezadoTabla">Experiencia</th>
                                            <th class="encabezadoTabla">Código</th>
                                            <th class="encabezadoTabla">Anfitrión</th>
                                            <th class="encabezadoTabla">Teléfono (Reservas)</th>
                                            <th class="encabezadoTabla">Email</th>
                                            <th class="encabezadoTabla">Fecha Compra</th>
                                            <th class="encabezadoTabla">Vencimiento</th>
                                            <th></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $compras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr style="text-align: center">
                                                    <td><img style="width: 100%" src="/storage/experiencias/<?php echo e($compra->experiencia->picture); ?>"></td>
                                                    <td><a href="<?php echo e(url('/experiencia-detalles/').'/'.$compra->experiencia->id); ?>"> <?php echo e($compra->experiencia->title); ?> </a></td>
                                                    <td style="font-weight: bold; color: #c29300"><?php if($compra->codigoCanjeable): ?> <?php echo e($compra->codigoCanjeable->code); ?> <?php else: ?> - <?php endif; ?></td>
                                                    <td><?php echo e($compra->experiencia->user->user_details != null ? $compra->experiencia->user->user_details->fake_name : '-'); ?></td>
                                                    <td><?php echo e($compra->experiencia->user->user_details != null ? $compra->experiencia->user->user_details->reservation_phone : "-"); ?></td>
                                                    <td><?php echo e($compra->experiencia->user->email); ?></td>
                                                    <td><?php echo e(Carbon\Carbon::parse($compra->created_at)->format('d-m-Y')); ?></td>
                                                    <td><?php if($compra->codigoCanjeable): ?> <?php echo e(date('d-m-Y', strtotime($compra->codigoCanjeable->date_exp))); ?> <?php else: ?> - <?php endif; ?></td>
                                                    <td style="text-align: center;">
                                                        <a title="Regalar código (Podes regalar este código a alguien para que lo utilice si así lo deseas)"
                                                           href='https://api.whatsapp.com/send?text=Hola,%20te%20hice%20un%20regalo%20en%20Yeah!%20
                                                            Para%20utilizarlo,%20comunicate%20con%20<?php echo e($compra->experiencia->user->user_details->fake_name); ?>

                                                               %20al%20<?php echo e($compra->experiencia->user->user_details->reservation_phone); ?>,%20o%20por%20mail
                                                               %20a%20<?php echo e($compra->experiencia->user->email); ?>,%20arregla%20un%20día%20y%20horario,%20y%20llevale%20el%20
                                                               código:%20<?php echo e($compra->codigoCanjeable->code); ?>%20¡Que%20lo%20disfrutes!' target='_blank'>
                                                            <img style="width: 20% !important" src='<?php echo e(asset('/imgs/whatsapp_off.svg')); ?>'>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div>
        </div>
    </div><!-- container -->
</section>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/YeahV2.0/resources/views/usuarios/canjes_latam.blade.php ENDPATH**/ ?>