<head>
    <link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/image-uploader.css')); ?>">
</head>
<?php $__env->startSection('contenido'); ?>
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title">Crear nuevo lugar</h3>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 form-group">
                                <form action="<?php echo e(url('/nuevo-lugar')); ?>" method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <label for="">Nombre del lugar:</label>
                                    <input type="text" name="name" class="form-control" placeholder="Elija el nombre" required />
                                    <br>

                                    <br>
                                    <label style="background-color: yellow">Imagen:</label>
                                    <div>
                                        <div class="imagenLugar" style="padding-top: .5rem;"></div>
                                    </div>
                                    <br>


                                    <label for="status">Elija el estado del lugar en el sitio:</label>
                                    <select name="status"  class="form-control" required>
                                        <option value="" disabled selected>Elija el estado</option>
                                        <option value="1">Activo</option>
                                        <option value="2">Pendiente</option>
                                    </select>
                                    <br>
                                    <br>

                                    <button type="submit" class="btn btn-success">Crear Lugar</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript" src="<?php echo e(asset('js/image-uploader.js')); ?>"></script>

<script>
        
$('.imagenLugar').imageUploader({
    label: 'Arrastra o hace click para cargar la imagen del lugar',
    imagesInputName: 'image',
    maxFiles:1,
});
</script>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/YeahV2.0/resources/views/admin/place/crear.blade.php ENDPATH**/ ?>