<style>
    .datepicker table td.disabled, .bootstrap-datetimepicker-widget table td.disabled:hover {
        background: rgba(0, 0, 0, 0.40) !important;
        color: black;
        cursor: not-allowed;
    }
    .btn-primary{
        color: white !important;
    }
    .form-control{
        color: #1d2124;
    }
    .btn-primary{
        font-size: 14px !important;
        font-weight: 600 !important;
    }
    label[for="dni"]#dni-label {
        font-size: 14px;
        font-weight: 600;
        background-color: var(--yellow);
        display: inline-block;
        transition: all .5s;
        cursor: pointer;
        padding: 15px 40px !important;
        color: white;
        width: fit-content;
        text-align: center;
    }
    input[type=”file”]#dni {
        width: 0.1px;
        height: 0.1px;
        opacity: 0;
        overflow: hidden;
        position: absolute;
        z-index: -1;
        display: none !important;
    }
    label[for="foto-personal"]#foto-label {
        font-size: 14px;
        font-weight: 600;
        background-color: var(--yellow);
        display: inline-block;
        transition: all .5s;
        cursor: pointer;
        padding: 15px 40px !important;
        color: white;
        width: fit-content;
        text-align: center;
    }
    input[type=”file”]#foto-personal {
        width: 0.1px;
        height: 0.1px;
        opacity: 0;
        overflow: hidden;
        position: absolute;
        z-index: -1;
        display: none !important;
    }
    .errors{
        color: #b41437;
        font-weight: bold;
    }
</style>

<?php $__env->startSection('contenido'); ?>

    <section id="reservar" class="pagar justify-content-center align-items-center">
        <div class="container">
            <form action="<?php echo e(url('/chequear-reserva')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="row d-flex justify-content-center text-center">
                    <div class="col-sm-12">
                        <h2 class="mb-1 mt-5">Revisar y pagar</h2>
                        <hr/>
                    </div>
                </div>
                <div class="row  justify-content-center text-center">
                    <div class="col-sm-3">
                        <input id="datepicker" name="date" placeholder="Ingrese la fecha deseada"
                               type="text" class="form-control" autocomplete="off" required />
                    </div>
                </div>
                <div class="row  justify-content-center text-center">
                    <div class="col-sm-3">
                        <label for="hours">Horario</label><br />
                        <?php if($experiencia->allowed_hour): ?>
                        <select name="hours" id="" class="form-control">
                            <option value="" hidden selected disabled>Ingrese un horario</option>
                            <?php for($i = str_replace(":00:00",'',$experiencia->allowed_hour->hora_desde);  $i<=str_replace(":00:00",'',$experiencia->allowed_hour->hora_hasta)   ; $i++): ?>
                            <?php if($i >12): ?>
                                <option value="<?php echo e($i); ?>:00:00"><?php echo e($i); ?>:00 Pm</option>
                            <?php else: ?>
                                <option value="<?php echo e($i); ?>:00:00"><?php echo e($i); ?>:00 Am</option>
                            <?php endif; ?>
                            <?php endfor; ?>
                        </select>
                        <?php else: ?>
                        <select name="hours" id="" class="form-control">
                            <option value="" hidden selected disabled>Ingrese un horario</option>
                            <?php for($i = 0; $i <= 24; $i++): ?>
                            <?php if($i >12): ?>
                            <option value="<?php echo e($i); ?>:00:00"><?php echo e($i); ?>:00 Pm</option>
                            <?php else: ?>
                            <option value="<?php echo e($i); ?>:00:00"><?php echo e($i); ?>:00 Am</option>
                            <?php endif; ?>
                            <?php endfor; ?>
                        </select>
                        <br>                        
                        <p><span style="color: red;font-weight: bold;text-transform: uppercase">Atencion: </span>El anfitrion de esta experiencia no asgino horarios aun, puedes reservar pero queda sujeto a cambios de horario a futuro  </p>
                        <?php endif; ?>
                        <input type="number" value="<?php echo e($experiencia->id); ?>" name="experiencia" style="display: none" hidden required />
                    </div>
                </div>
                <br>
                <br>
                <?php if($experiencia->needs_validation == null): ?>
                    <?php if($user->verified == 0): ?>
                        <div class="row justify-content-center text-center">
                            <div class="col-sm-6">
                                <h3>Requiere validación</h3>
                                <p>La experiencia deseada, requiere que su usuario sea verificado.
                                    Por favor, envíe una foto de su DNI o documento válido, y una foto suya,
                                    la cual será revisada por los administradores.</p>
                            </div>
                        </div>
                        <div class="row justify-content-center text-center">
                            <div class="col-6">
                                <label for="dni" id="dni-label"><i class="fas fa-file-upload"></i> Foto del documento</label>
                                <input type="file"
                                       name="dni" id="dni"
                                       style="display: none;"/>

                            </div>
                        </div>
                        <br>
                        <div class="row justify-content-center text-center">
                            <div class="col-6">
                                <label for="foto-personal" id="foto-label"><i class="fas fa-file-upload"></i> Foto Personal</label>
                                <input type="file"
                                       name="foto-personal" id="foto-personal"
                                       style="display: none;"/>

                            </div>
                        </div>
                        <br>
                        <div class="row justify-content-center text-center">
                            <div class="col-sm-6">
                                <p>Recuerde llevar su documento el día de la experiencia, ya que el anfitrión puede
                                    solicitarlo.</p>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <br>
                <?php if(isset($error)): ?>
                    <div class="row justify-content-center text-center">
                        <div class="col-sm-6">
                            <p class="errors"><?php echo e($error); ?></p>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="row  justify-content-center text-center">
                    <div class="col-sm-3">
                        <button type="submit" class="btn btn-primary">Reservar</button>
                    </div>
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/jquery-ui.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.8.0/css/bootstrap-datepicker.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
    <script>
        // Leo los dias laborales de la relacion en la bd
        var dias_laborales=<?php echo json_encode($experiencia->allowed_hour->dias_laborales, 15, 512) ?>;
        // Transformo el string en un array y quito los guiones para que no formen parte del array
        dias_laborales=Array.from(dias_laborales.replace('-',''));
        // El array es un array de strings , para eso lo transformo en integer
        dias_laborales = dias_laborales.map(function (x) { 
            return parseInt(x, 10); 
            });
        
        
        const url = "<?php echo e(url('/reservas/experiencia') . '/' . $experiencia->id); ?>";
        $.get(url, function (data, status){
            disableDates = data;
            disableDates = disableDates.map((element)=> {
                var d = new Date(element);
                return `${d.getDate()+1}-${d.getMonth()+1}-${d.getFullYear()}`;
            });
        });

        var array=<?php echo json_encode($fechas_reservadas, 15, 512) ?>;

        $('#datepicker').datepicker({
            format: 'yyyy-mm-dd',
            minDate: 0,
             beforeShowDay: function(date){
                var day = jQuery.datepicker.formatDate('yy-mm-dd', date);
                return [ array.indexOf(day) == -1 ]
                }
        });
    //     $('#datepicker').datepicker('option', 'beforeShowDay', function(date){
    //         var day = date.getDay();
    //         return [(dias_laborales.indexOf(day) != -1)];
    // });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/YeahV2.0/resources/views/experiencias/reservar.blade.php ENDPATH**/ ?>