<?php $__env->startSection('styles'); ?>
<style>
    #my-custom-nav-bar{
        display: none;
    }
    #button-toggle-navigation{
        display: none;
    }
    .categoria-background{
        background-size: cover;
        background-repeat: no-repeat;
        min-height: 150px;
        max-height: 220px;
        padding: 0%;
    }
    .lugar-background{
        background-position: center;
        background-size: contain;
        min-height: 150px;
        max-height: 220px;
        padding: 0%;
    }
    .txt-cat{
        font-weight: 600;
    }
    .titulo-lugar{
        font-weight: 600;
        position: absolute;
        top: 5%;
    }
    .flag-container{
        display: inline;
    }
    .flags-languaje{
        display: inline;
        width: 20px;
    }

    #nav-bar-icon-shower:hover + #hidden-profile{
        display: block;
    }

    #hidden-profile{
        display: none;
        background-color: white;
        color: black;
        position: absolute;
        right: 5%;
        top: 100%;
        width: 130px;
        border: 1px solid black;
        border-radius: 15px;
        padding-top: 20%;
    }

    .nav-hidden{
        padding-left: 15px;
        list-style-type: none;
    }

    .nav-hidden li{
        margin-bottom: 5px;
    }

    .link-nav{
        color: black;
    }

    .link-nav:hover{
        color: #c29300;
    }

    .form-control-custom{
        padding: 1rem;
        border: none;
    }

    #cart-list-expe
    {
        max-height: 50vh;
        overflow-y: scroll;
    }

    .add-to-cart-d-btn{
        cursor: pointer;
    }

    @media  screen and (max-width: 700px){
        #links-nav-bar-home {
            position: absolute;
            right: 1rem;
            top: 0.3em;
            display: block;
        }
    }

</style>
<?php $__env->stopSection(); ?>
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
</head>
<?php $__env->startSection('contenido'); ?>

    <?php echo $__env->make('components.front-end.cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="experiencias js-fullheight">
        <div class="js-fullheight" style="background-image: url(<?php echo e(asset('imgs/banner_01.jpg')); ?>); height: 100vh !important;">

            <div> <!-- Inicio div top -->
                <div class="logo-blanco"><img src="<?php echo e(asset('imgs/logo-yeah-blanco.png')); ?>" alt=""></div>
                <?php if(auth()->guard()->check()): ?>
                    <div class="home-links-top" id="links-nav-bar-home">
                        <a href="<?php echo e(route('home-users')); ?>" id="nav-bar-icon-shower" onmouseover="showMenu()"><i class="fas fa-user" id="user-fa-icon"></i></a>&nbsp;
                        <div id="hidden-profile" onmouseleave="hideMenu()">
                            <ul class="nav-hidden">
                                <li><a href="<?php echo e(url('/inicio')); ?>" class="link-nav"><i class="fas fa-home"></i>&nbsp; Perfil</a></li>
                                <li><a href="<?php echo e(url('/logout')); ?>" class="link-nav"><i class="fas fa-sign-out-alt"></i>&nbsp; Cerrar sesión</a></li>
                            </ul>
                        </div>

                        | <div class="flag-container">
                            <a href="<?php echo e(url('/en')); ?>"><img src="<?php echo e(asset('imgs/svgs/uk_flag.svg')); ?>" alt="" class="flags-languaje"></a>&nbsp;
                            <a href="<?php echo e(url('/es')); ?>"><img src="<?php echo e(asset('imgs/svgs/Bandera_de_España.svg')); ?>" class="flags-languaje" alt=""></a>&nbsp;
                        </div>

                        | <div class="flag-container">
                            <i id="cart-oppener" class="fas fa-shopping-cart" style="color: #ffc107;"></i>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="home-links-top" id="links-nav-bar-home">
                        <a href="<?php echo e(url('/login')); ?>" data-toggle="modal" data-target="#IniciarSesion">Iniciar sesión</a> |
                        <a href="<?php echo e(url('/register')); ?>">Registrarse</a>
                        |
                        <a href="<?php echo e(url('/en')); ?>"><img src="<?php echo e(asset('imgs/svgs/uk_flag.svg')); ?>" alt="" class="flags-languaje"></a>&nbsp;
                        <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('imgs/svgs/Bandera_de_España.svg')); ?>" class="flags-languaje" alt=""></a>&nbsp;
                        |
                        <div class="flag-container">
                            <i id="cart-oppener" class="fas fa-shopping-cart" style="color: #ffc107;"></i>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="d-block d-sm-none"><!--Inicio Contenido mobile -->
                        <button id="button-toggle-navigation" class="navbar-toggler navbar-top" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">   <!-- Button con display:none (vaya uno a saber porque) -->
								<span class="navbar-toggler-icon">
									<svg width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-list" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" d="M2.5 11.5A.5.5 0 0 1 3 11h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4A.5.5 0 0 1 3 7h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4A.5.5 0 0 1 3 3h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5z"/>
									</svg>
								</span>
                        </button><!-- Fin Button con display:none -->
                        <div style="display: block !important" class="collapse navbar-collapse search-collapse-top" id="searchContent"><!--Inicio Buscador mobile -->
                            <form action="<?php echo e(url('/busqueda')); ?>" method="GET" id="formSearchH">

                                <input name="busqueda" type="text" autocomplete="off"
                                       class="form-control-custom" style="width: 100%;"
                                       required class="nav-search placeholder" id="searchH"
                                       name="busqueda" placeholder="Buscar: Spa, Cenas, Cursos...">

                                <button class="btn-selects-search" style="margin: 0">
                                    Buscar &nbsp;
                                    <span class="icon-search" id="search-nav-sticky" aria-hidden="true"></span>
                                </button>

                            </form>
                        </div><!--Fin Buscador mobile -->
                </div> <!-- Fin Contenido mobile -->
            </div> <!-- Fin div top -->

            <div class="row-aligned-buttons experiencias-row-buttons" id="experiencias-row-buttons">

                <div class="sad">
                    <form action="<?php echo e(url('/busqueda')); ?>" method="GET" id="formSearchH">

                        <div class="nav-selects" id="nav-selects-container">
                            <!--
                            <label class="input-label">Categoria</label>
                            -->
                            <div class="nav-select-wrap">
                                <select class="nav-select" name="category">
                                    <option disabled selected hidden value="X">Categoría</option>
                                    <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($categoria->id); ?>"><?php echo e($categoria->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="nav-select-wrap">
                                <select class="nav-select" name="provincia">
                                    <option disabled selected hidden value="X">Provincia</option>
                                    <option value="CABA">Ciudad Autónoma de Buenos Aires</option>
                                    <option value="Buenos Aires">Buenos Aires</option>
                                    <option value="Catamarca">Catamarca</option>
                                    <option value="Chaco">Chaco</option>
                                    <option value="Chubut">Chubut</option>
                                    <option value="Córdoba">Córdoba</option>
                                    <option value="Corrientes">Corrientes</option>
                                    <option value="Entre Ríos">Entre Ríos</option>
                                    <option value="Formosa">Formosa</option>
                                    <option value="Jujuy">Jujuy</option>
                                    <option value="La Pampa">La Pampa</option>
                                    <option value="La Rioja">La Rioja</option>
                                    <option value="Mendoza">Mendoza</option>
                                    <option value="Misiones">Misiones</option>
                                    <option value="Neuquén">Neuquén</option>
                                    <option value="Río Negro">Río Negro</option>
                                    <option value="Salta">Salta</option>
                                    <option value="San Juan">San Juan</option>
                                    <option value="San Luis">San Luis</option>
                                    <option value="Santa Cruz">Santa Cruz</option>
                                    <option value="Santa Fe">Santa Fe</option>
                                    <option value="Santiago del Estero">Santiago del Estero</option>
                                    <option value="Tierra del Fuego">Tierra del Fuego</option>
                                    <option value="Tucuman">Tucuman</option>
                                </select>
                            </div>

                            <div class="nav-select-wrap">
                                <select class="nav-select" name="price">
                                    <option hidden selected value="X">Precio</option>
                                    <option value="<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->first()); ?>-<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->last()); ?>">Desde $<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->first()); ?></option>
                                    <option value="<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->first()); ?>-<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->median()); ?>">Desde $<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->first()); ?> hasta $<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->median()); ?></option>
                                    <option value="<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->median()); ?>-<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->last()); ?>">Desde $<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->median()); ?> hasta $<?php echo e($experiencias->sortBy('final_price')->pluck('final_price')->last()); ?></option>
                                </select>
                            </div>
                            <div class="nav-input-wrap">
                                <input type="text" class="nav-search placeholder" id="searchH" name="busqueda" placeholder="Buscar: spa, etc.">
                            </div>
                            <button class="btn-selects-search">
                                <div class="nav-btn-search">Buscar</div>
                                <span class="icon-search" id="search-nav-sticky" aria-hidden="true"></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Fin Ajustes - Nuevo menu de items -->
            <div class="overlay"></div>
            <div class="container">
                <div class="row slider-text align-items-center" data-scrollax-parent="true">
                    <div class="col-md-12 col-sm-12 text-left ftco-animate">
                        <h4 class="cursiva subtitulo">viví & regalá</h4>
                        <h1 class="mb-4">EXPERIENCIAS</h1>
                        <p id="buttons-header">
                            <a href="<?php echo e(url('/todas')); ?>" class="btn btn-primary btn-outline-primary p-3 px-xl-4 py-xl-3">Regalá experiencias</a>
                            <input type="hidden" name="busqueda" value="">
                            <a href="<?php echo e(url('/abrir-regalo')); ?>" class="btn btn-primary p-3 px-xl-4 py-xl-3">Abrí tu regalo</a>
                        </p>
                    </div>
                </div>

                <div class="row align-items-end text-left banner-items" id="empresas">
                    <div class="col-sm-3">
                        <a href="<?php echo e(route('contacto.empresa')); ?>" id="yellow-color"><span><img src="<?php echo e(url('imgs/briefcase.svg')); ?>" class="yellow"></span>
                            Empresas </a>
                    </div>
                    <div class="col-sm-3">
                        <a href="<?php echo e(route('contacto')); ?>" id="yellow-color"><span><img src="<?php echo e(url('imgs/email.svg')); ?>" class="yellow"></span> Contacto
                        </a>
                    </div>
                    <div class="col-sm-6">
                        <a href="<?php echo e(url('/registroAnfitriones')); ?>" id="yellow-color"><span><img src="<?php echo e(url('imgs/star.svg')); ?>" class="yellow"></span> Quiero ser
                            anfitrión/a </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- SECCIÓN ELEGÍ CATEGORÍA -->
    <section class="ftco-section ftco-wrap-about ftco-no-pb">
        <div class="container">
            <div class="row justify-content-start">
                <div class="col-md-12">
                    <div class="heading-section mb-5 mt-5 text-left">
                        <h3 class="mb-2">Elegí categoría</h3>
                        <div class="zigzag"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- CATEGORIAS DENTRO DEL CONTAINER -->
        <div class="container-fluid">
            <div class="row">
                <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-3 categoria-background" id=""
                         style="
                             background: linear-gradient(
                                rgba(0, 0, 0, 0.3),
                                rgba(0, 0, 0, 0.3)),
                             url(<?php echo e("/storage/categorias/" . $categoria->picture); ?>),
                             no-repeat;
                             background-position: center;
                             background-size: cover;
                             background-repeat: no-repeat;
                             ;">
                        <div class="lugar2 linkLugar img d-flex align-items-center justify-content-center">
                            <div class="content-cat">
                                <a href="<?php echo e(url('/categoria') . '/' . $categoria->id); ?>"><div class="content txt-cat text-center"><?php echo e($categoria->title); ?></div></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>


    <!-- SECCIÓN ELEGÍ EL LUGAR -->
    <section class="ftco-section" id="elegi-el-lugar">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section ftco-animate">
                    <!-- <span class="subheading">Chef</span> -->
                    <h3>Elegí el lugar</h3>
                    <div class="zigzag"></div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <?php $__currentLoopData = $lugares; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lugar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-3 lugar-background" id="lugares-home"
                         style="
                             background: linear-gradient(
                             rgba(0, 0, 0, 0.3),
                             rgba(0, 0, 0, 0.3)),
                             url(<?php echo e("/storage/places/" . $lugar->image); ?>),
                             no-repeat;
                             background-position: center;
                             background-size: cover;
                             background-repeat: no-repeat;
                        ">
                        <div class="" class="lugar2 linkLugar img d-flex align-items-center justify-content-center">
                            <a href="<?php echo e(url('/lugar') . '/' . $lugar->id); ?>" class="lugar2 linkLugar img d-flex align-items-center justify-content-center">
                                <span class="titulo-lugar"><?php echo e($lugar->name); ?></span>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

    </section>

    <section class="ftco-section" id="destacadas">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section ftco-animate">
                    <!-- <span class="subheading">Chef</span> -->
                    <h3>Destacadas</h3>
                    <!-- <hr> -->
                    <div class="zigzag"></div>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $experiencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experiencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-3 ftco-animate">
                    <div class="blog-entry">
                        <div class="destacadas-icons">
                            <a href="#" class="float-right meta-share abrirModalShare"><span class="icon-share"></span></a>
                            <a href="<?php echo e(url('/experiencia/favorita') .'/'. $experiencia->id); ?>" class="float-right meta-like agregarLikes" data-exid=""><span class="icon-heart"></span></a>
                            <?php if($experiencia->reservation != "Con reserva"): ?>
                                <?php if(auth()->guard()->check()): ?>
                                <button onclick="addToCart(<?php echo e($experiencia->id); ?>, '<?php echo e($experiencia->title); ?>', '<?php echo e($experiencia->picture); ?>', '<?php echo e($experiencia->final_price); ?>')"
                                    class="addToCartBtn"><i class="fas fa-cart-plus"></i></button>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <a href="<?php echo e(url('/experiencia/') .'/'. $experiencia->id); ?>"
                           class="block-20"
                           style="background-color: gray;
                               background-image: url('/storage/experiencias/<?php echo e($experiencia->picture); ?>');">
                        </a>
                        <div class="text pt-3 pb-4">
                            <h3 class="heading"><a href="<?php echo e(url('/experiencia/') .'/'. $experiencia->id); ?>"><?php echo e($experiencia->title); ?></a></h3>
                            <p><small><?php echo e($experiencia->city); ?>, <?php echo e($experiencia->province); ?></small></p>
                            <p><?php echo Str::limit($experiencia->description, 200, '...'); ?></p>
                            <p class="clearfix">
                                <a href="<?php echo e(url('/experiencia') . '/' . $experiencia->id); ?>" class="float-left ver-mas">Ver más</a>
                                <?php if($experiencia->reservation != "Con reserva"): ?>
                                    <?php if(auth()->guard()->check()): ?>
                                        <a onclick="addToCart(<?php echo e($experiencia->id); ?>, '<?php echo e($experiencia->title); ?>', '<?php echo e($experiencia->picture); ?>', '<?php echo e($experiencia->final_price); ?>')" class="float-left ver-mas ml-1 add-to-cart-d-btn">
                                            Agregar <i class="fas fa-shopping-cart"></i></a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <?php echo $__env->make('components.modal-Yeah',['texto'=> 'Bienvenido a YeAH!<br> Tu contraseña es la definida por defecto, deberias cambiarla. <br> Tambien revisa los nuevos terminos y condiciones!','ruta'=>route('perfil')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('custom-scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
    <script>
        $(function(){
            $('.selectpicker').selectpicker();
        });
        $('document').ready(function(){
            if(<?php echo json_encode($modal); ?>){
                $('#GuardarCambios').css('overflow-y', 'auto');
                $('#GuardarCambios').modal('show');
            }
        });

        const menu = document.getElementById("hidden-profile");
        function showMenu()
        {
            menu.style.display = "block";
        }

        function hideMenu()
        {
            menu.style.display = "none";
        }

    </script>

    <script src="<?php echo e(asset('js/cart.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/YeahV2.0/resources/views/welcome.blade.php ENDPATH**/ ?>