<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
        <th>#</th>
        <th style="cursor: pointer" >Fecha Venta<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Codigo<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Título<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Anfitrion<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Precio<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Ciudad<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Dirección<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Requiere reserva<i class="ml-4 fas fa-caret-down"></i></th>
        <th>Estado de la compra</th>
        <th>Pendiente / Utilizada</th>
        <th>Eliminar</th>
    </tr>
    </thead>
    <tbody>
    <?php $__empty_1 = true; $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td>
                <p><?php echo e($venta->id); ?></p>
            </td>
            <td>
                <p><?php echo e($venta->created_at); ?></p>
            </td>
            <td>
                <p><?php echo e($venta->codigoCanjeable ? $venta->codigoCanjeable->code : 'Sin codigo'); ?></p>
            </td>
            <td>
                <p><?php echo e($venta->experiencia->title); ?></p>
            </td>
            <td>
                <p><?php echo e($venta->experiencia->user->name); ?></p>
            </td>
            <td>
                <p>$ <?php echo e($venta->amount); ?>.00</p>
            </td>
            <td>
                <p><?php echo e($venta->experiencia->city); ?></p>
            </td>
            <td>
                <p><?php echo e($venta->experiencia->place); ?></p>
            </td>
            <td>
                <p><?php echo e($venta->experiencia->reservation == 1 ? "Si" : "No"); ?></p>
            </td>
            <td>
                <p><?php echo e($venta->approved == 1 ? "Aprobada" : "Rechazada"); ?></p>
            </td>
            <td>
                <?php if($venta->codigoCanjeable): ?>
                    <p> <?php echo e($venta->codigoCanjeable->used == 1 ? "Utilizado" : "Pendiente de uso"); ?></p>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form action="<?php echo e(route('venta.delete',$venta)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button style="border: none;background-color: transparent"><i style="color: gray" class="fa fa-trash"></i></button>
                    </form>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <td >No hay registros para mostrar</td>
    <?php endif; ?>
    </tbody>
</table>
<div class="d-flex justify-content-center" style="padding-bottom: 10px;">
    <?php echo e($ventas->links()); ?>

</div>
<?php /**PATH /var/www/html/YeahV2.0/resources/views/admin/components/tablas/ventas-sin-reserva.blade.php ENDPATH**/ ?>