<?php $__env->startSection('contenido'); ?>

    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container">
            <?php echo $__env->make('components.profile-header', ['user'=>$user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="container">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Mis Experiencias</h3>
                    <hr/>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <a href="<?php echo e(url('/crear-experiencia')); ?>" class="btn btn-primary">Crear Experiencia</a>
                </div>
            </div>
        </div>
        <?php if($errors->any()): ?>
            <h4 id="message" style="text-align: center"><?php echo e($errors->first()); ?></h4>
            <br>
        <?php endif; ?>
        <div class="row pb-2">
            <div class="col-md-12 mb-5 ">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">
                                    <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                        <thead class="thead-dark">
                                        <tr>
                                            <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                            <th class="encabezadoTabla">Experiencia</th>
                                            <th class="encabezadoTabla">Precio</th>
                                            <th class="encabezadoTabla">Ubicacion</th>
                                            <th class="encabezadoTabla">Ciudad</th>
                                            <th class="encabezadoTabla">Provincia</th>
                                            <th class="encabezadoTabla">Fecha de creacion</th>
                                            <th class="encabezadoTabla">Duracion</th>
                                            <th class="encabezadoTabla">Activa</th>
                                            <th class="encabezadoTabla">Editar Experiencia</th>
                                            <th class="encabezadoTabla">Editar Horarios</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $experiencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experiencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><img style="width: 100%" src="/storage/experiencias/<?php echo e($experiencia->picture); ?>"></td>
                                                <td><?php echo e($experiencia->title); ?></td>
                                                <td>$<?php echo e($experiencia->price); ?></td>
                                                <td><?php echo e($experiencia->location); ?></td>
                                                <td><?php echo e($experiencia->city); ?></td>
                                                <td><?php echo e($experiencia->province); ?></td>
                                                <td><?php echo e($experiencia->created_at); ?></td>
                                                <td><?php echo e($experiencia->hours); ?></td>
                                                <td><?php echo $experiencia->valid == 1 ? "<span style='font-weight: bold;'>Si</span>" : "<span style='font-weight: bold;'>No</span>"; ?></td>
                                                <td>
                                                    <a href="<?php echo e(url('/editar-experiencia/'.$experiencia->id)); ?>">
                                                        <i class="fas fa-pencil-alt"></i>
                                                    </a>
                                                </td>
                                                <td>
                                                    <?php if($experiencia->reservation == "Con reserva"): ?>
                                                        <a href="<?php echo e(route('bloquear-horario',$experiencia)); ?>" style="line-height:0px;color: white" class="btn btn-primary">Asignar horario</a>
                                                    <?php else: ?>
                                                        <p>S/Reserva</p>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div>
        </div>
    </section>

    <script>
        $message = document.getElementById("message");
        if ($message != null) {
            setTimeout(function () {
                $message.remove();
            }, 4400);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/YeahV2.0/resources/views/anfitriones/mis-experiencias.blade.php ENDPATH**/ ?>