<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
            <th style="cursor: pointer" >#<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Estrellas<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Experiencia<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Usuario</th>
            <th style="cursor: pointer" >Opinión<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Activa</th>
            <th style="cursor: pointer" >Validar</th>
            <th style="cursor: pointer" >Borrar</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $califications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $calification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <p><?php echo e($calification->id); ?></p>
            </td>
            <td style="min-width: 9rem;">
                <p>
                    <?php echo e($calification->stars); ?>

                    <?php for($i = 0; $i < $calification->stars; $i++): ?>
                        <i class="fas fa-star"></i>
                    <?php endfor; ?>
                </p>
            </td>
            <td>
                <p><?php echo e($calification->experiencia != null ? $calification->experiencia->title : "-"); ?></p>
            </td>
            <td>
                <p><?php echo e($calification->user->name); ?></p>
            </td>
            <td>
                <p><?php echo e($calification->opinion); ?></p>
            </td>
            <td>
                <p><?php echo $calification->valida_front == 1 ? "<strong style='color: #006600;'>Si</strong>" : "<strong style='color: #990000;'>No</strong>"; ?></p>
            </td>
            <td>
                <form action="<?php echo e(url('/saveCalification')); ?>" method="post" style="margin-bottom: 0px;">
                    <div style="justify-content: space-around" class="row">
                        <?php echo csrf_field(); ?>
                        <input type="number"
                               name="id" value="<?php echo e($calification->id); ?>"
                               style="display:none;" hidden required />
                        <button style="border: none;background-color: transparent" type="submit">
                            <i class="fas fa-check"></i>
                        </button>
                    </div>

                </form>
            </td>
            <td>
                <form action="<?php echo e(url('/borrarCalification')); ?>" method="post" style="margin-bottom: 0px;">
                    <div style="justify-content: space-around" class="row">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <input type="number"
                               name="id" value="<?php echo e($calification->id); ?>"
                               style="display:none;" hidden required />
                        <button style="border: none;background-color: transparent" type="submit">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>

                </form>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<div class="d-flex justify-content-center">
    <?php echo e($califications->links()); ?>

</div>
<?php /**PATH /var/www/html/YeahV2.0/resources/views/admin/components/tablas/califications.blade.php ENDPATH**/ ?>