<?php $__env->startSection('contenido'); ?>

    <!-- SECCIÓN Mis Compras -->
    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container-fluid">
            <?php echo $__env->make('components.profile-header', ['user'=>$user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="container-fluid">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Mis Regalos Recibidos</h3>
                    <hr/>
                </div>
            </div>
            <div class="row pb-2">
                <div class="col-md-12 mb-5 ">
                    <div class="container-fluid">
                        <div class="row align-items-left">
                            <div class="col-md-12">
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                        <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                            <thead class="thead-dark">
                                            <tr>
                                                <th class="encabezadoTabla" style="width: 10%;">Foto</th>
                                                <th class="encabezadoTabla">Experiencia</th>
                                                <th class="encabezadoTabla">Anfitrión</th>
                                                <th class="encabezadoTabla">Código</th>

                                                <th class="encabezadoTabla">Ubicación</th>
                                                <th class="encabezadoTabla">Ciudad</th>
                                                <th class="encabezadoTabla">Teléfono anfitrión</th>

                                                <th class="encabezadoTabla">Estado</th>
                                                <th class="encabezadoTabla">Vencimiento</th>
                                                <th class="encabezadoTabla">Fecha de emision</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $regalos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $regalo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><img style="width: 100%" src="/storage/experiencias/<?php echo e($regalo->experiencia->picture); ?>"></td>
                                                    <td><a href="<?php echo e(url('/experiencia-detalles/').'/'.$regalo->experiencia->id); ?>"> <?php echo e($regalo->experiencia->title); ?> </a></td>
                                                    <td><?php echo e($regalo->experiencia->user->user_details->fake_name); ?></td>
                                                    <td style="color: #c29300; font-weight: bold;"><?php echo e($regalo->code); ?></td>
                                                    <td><?php echo e($regalo->experiencia->location); ?></td>
                                                    <td><?php echo e($regalo->experiencia->city); ?></td>
                                                    <td><?php echo e($regalo->experiencia->user->user_details->reservation_phone); ?></td>
                                                    <td><?php echo e($regalo->used == 0 ? "No usado" : "Utilizado"); ?></td>
                                                    <td><?php echo e(\Carbon\Carbon::parse($regalo->date_exp)->format('d-m-Y')); ?></td>
                                                    <td><?php echo e($regalo->created_at->format('d/m/Y')); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- col-md-12 -->
                        </div><!-- row -->
                    </div><!-- container -->
                </div>
            </div>
        </div><!-- container -->
    </section>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/YeahV2.0/resources/views/usuarios/regalos_recibidos.blade.php ENDPATH**/ ?>