<style>
    .hidden{
        display: none;
    }
</style>
<?php $__env->startSection('contenido'); ?>
<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">Ventas <?php echo e($tipo); ?></h3>
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="table_data" class="display expandable-table" style="width:100%">
                                    <thead>
                                    <tr>
                                        <th style="cursor: pointer; min-width: 115px" >Fecha de Carga<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Codigo<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Quien canjea<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Quien canjea (email)<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Experiencia<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Anfitrion<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Precio (Experiencia)<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th>Estado</th>
                                        <th>Borrar</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <p><?php echo e($venta->created_at->format('d-m-Y')); ?></p>
                                            </td>
                                            <td>
                                                <p><?php echo e($venta->codigoCanjeable->code); ?></p>
                                            </td>
                                            <td>
                                                <p><?php echo e($venta->user->name); ?></p>
                                            </td>
                                            <td>
                                                <p><?php echo e($venta->user->email); ?></p>
                                            </td>
                                            <td>
                                                <p><?php echo e($venta->experiencia->title); ?></p>
                                            </td>
                                            <td>
                                                <p><?php echo e($venta->experiencia->user->name); ?></p>
                                            </td>
                                            <td>
                                                <p>$ <?php echo e($venta->amount); ?>.00</p>
                                            </td>
                                            </td>
                                            <td>
                                                <p><?php echo e($venta->codigoCanjeable->used == 1 ? "Utilizada" : "Pendiente de uso"); ?></p>
                                            </td>
                                            <td>
                                                <div style="justify-content: space-around" class="row">
                                                    <form action="<?php echo e(route('venta.delete',$venta)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <button style="border: none;background-color: transparent"><i style="color: gray" class="fa fa-trash"></i></button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <td >No hay registros para mostrar</td>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                                <div class="d-flex justify-content-center" style="padding-bottom: 10px;">
                                    <?php echo e($ventas->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/YeahV2.0/resources/views/admin/venta/canje-tabla.blade.php ENDPATH**/ ?>