<?php

use App\Http\Controllers\CartController;
use App\Http\Controllers\PreguntasController;
use App\Http\Controllers\RegalosController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\ExperienciaController;
use App\Http\Controllers\AnfitrionController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\TuristaController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Mailer\Mailer;
use Illuminate\Support\Facades\Session;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [HomeController::class, 'home'])->name('home');

Route::get('/es', function (){ return redirect('/'); } );

Route::get('/experiencia/{id}', [ExperienciaController::class, 'experiencia']);

Route::get('/terminos_y_condiciones', function () {return view('terminos_y_condiciones');})->name('terminos_y_condiciones');
Route::get('/preguntas_frecuentes', function () {return view('preguntas_frecuentes');})->name('preguntas_frecuentes');

Route::get('/no-encontrado', [HomeController::class, 'notFound']);

Route::get('/contacto', [HomeController::class, 'formulario_contacto'])->name('contacto');
Route::post('/contacto', [HomeController::class, 'procesar_formulario_contacto']);

Route::get('/contacto/empresa', [HomeController::class, 'formulario_empresas'])->name('contacto.empresa');
Route::post('/contacto/empresa', [HomeController::class, 'procesar_formulario_empresas']);
Route::get('/busqueda', [ExperienciaController::class, 'busqueda'])->name('busqueda');

Route::get('/todas', [ExperienciaController::class, 'get_all'])->name('experiencias.todas');

Route::get('/mas-experiencias/{anfitrion}', [ExperienciaController::class, 'experienciasDelAnfitrion'])->name('experiencias-del-anfitrion');

Route::get('/categoria/{id}', [HomeController::class, 'categoria']);
Route::get('/lugar/{id}', [HomeController::class, 'lugar']);


Route::group(['middleware'=>'auth'], function (){
    //perfil
    Route::get('/inicio', [UsersController::class, 'inicio'])->name('home-users');
    Route::get('/perfil', [UsersController::class, 'perfil'])->name('perfil');
    Route::put('/perfil/{user}', [UsersController::class, 'update'])->name('perfil.update');

    Route::get('/mis-dudas', [PreguntasController::class, 'misDudas'])->name('mis-dudas');
    Route::get('/dudas-consultadas', [PreguntasController::class, 'dudasConsultadas'])->name('dudas-pendientes');

    //dudas
    Route::post('/preguntar', [PreguntasController::class, 'setPregunta']);

    //favoritos /mis-favoritos
    Route::get('/experiencia/favorita/{id}', [ExperienciaController::class, 'marcarFavorita']);
    Route::get('/experiencia/quitar-favorito/{id}', [ExperienciaController::class, 'quitarFavorita']);

    Route::get('/mis-favoritos', [UsersController::class, 'mis_favoritos']);

    //perfil de los anfitriones
    Route::get('/mis-reservas', [AnfitrionController::class, 'mis_reservas'])->name('mis-reservas');
    Route::get('/mis-ventas', [AnfitrionController::class, 'mis_ventas'])->name('mis-ventas');
    Route::get('/mis-experiencias', [AnfitrionController::class, 'mis_experiencias'])->name('mis-experiencias');
    Route::get('/crear-experiencia', [AnfitrionController::class, 'crear_experiencias']);
    Route::post('/experiencia-guardada', [AnfitrionController::class, 'guardarNuevaExpe']);

    // Route::get('/mis-experiencias', [AnfitrionController::class, 'mis_experiencias']);
    Route::get('/editar-experiencia/{id}', [AnfitrionController::class, 'editar_experiencia']);

    Route::post('/editar-experiencia-guardar', [AnfitrionController::class, 'guardar_experiencia_editada']);
    Route::get('/mis-experiencias', [AnfitrionController::class, 'mis_experiencias'])->name('mis-experiencias');

    Route::get('/mis-reservas', [AnfitrionController::class, 'mis_reservas'])->name('mis-reservas');
    Route::get('/reservas/experiencia/{id}', [ExperienciaController::class, 'reservasExperiencia']);
    Route::get('/redimir-codigo', [AnfitrionController::class, 'redimirCodigo'])->name('validar-codigo');
    Route::get('/bloquear-horario/{experiencia}', [AnfitrionController::class, 'bloquearHorario'])->name('bloquear-horario');
    Route::post('/bloquear-horario/{experiencia}', [AnfitrionController::class, 'bloquearHorarioPost'])->name('bloquear-horario-post');
    Route::get('/bloquear-fecha', [AnfitrionController::class, 'bloquearFecha'])->name('bloquear-fecha');
    Route::post('/bloquear-fecha', [AnfitrionController::class, 'bloquearCodigoPost'])->name('bloquear-fecha-post');
    Route::post('/redimir-codigo', [AnfitrionController::class, 'verificarCodigo']);

    //perfil de los turistas
    Route::get('/compras', [TuristaController::class, 'mis_compras'])->name('compras');
    Route::get('/mis_codigos', [TuristaController::class, 'mis_codigos'])->name('compras');
    Route::get('/experiencias-reservadas', [TuristaController::class, 'mis_reservas']);
    Route::get('/experiencias-regaladas', [TuristaController::class, 'regalos_realizados']);
    Route::get('/regalos-abiertos', [TuristaController::class, 'regalos_recibidos'])->name('regalos-recibidos');
    Route::get('/experiencia-detalles/{id}', [TuristaController::class, 'experiencia_detalles']);
    Route::get('/calificar-experiencia/{id}', [TuristaController::class, 'calificar']);
    Route::post('/guardar-calificacion', [TuristaController::class, 'storeCalification']);
    Route::get('/canjes/latam', [TuristaController::class, 'mis_canjes']);


    //abrir regalos
    Route::get('/abrir-regalo', [RegalosController::class, 'abrir_regalo_vista'])->name('abrir-regalo');
    Route::post('/abrir-regalo', [RegalosController::class, 'abrir_regalo']);

    //compras regalo
    Route::get('/experiencia/{id}/regalar', [RegalosController::class, 'prepararRegalo']);
    Route::post('/experiencia/pagar-regalo', [RegalosController::class, 'pagarRegalo']);
    Route::get('/experiencia-fin-pago-regalo', [RegalosController::class, 'finCompra'])->name('final.compra.regalo');

    Route::get('/experiencia-en-espera', [RegalosController::class, 'errorEnLaCompra'])->name('error.compra.regalo');
    Route::get('/experiencia-error-al-comprar', [RegalosController::class, 'compraEnEspera'])->name('espera.compra.regalo');

    //compra no regalo
    Route::get('/experiencia/{id}/reservar', [ExperienciaController::class, 'reservarExperiencia']);
    Route::post('/chequear-reserva', [ExperienciaController::class, 'chequearReserva']);
    Route::get('/experiencia/{id}/pagar', [ExperienciaController::class, 'pagarExperiencia'])->name('experiencia.comprar');
    Route::post('/experiencia/pagar-sin-reserva', [ExperienciaController::class, 'procesarPago']);
    Route::get('experiencia-fin-pago-sin-reserva', [ExperienciaController::class, 'procesarPago']);

    //
    Route::post('/experiencia/pagar', [ExperienciaController::class, 'procesarPago']);

    //pagar carrito de nombre
    Route::post('/carrito/pagar', [CartController::class, 'pagarExperiencias']);
    Route::get('/pagar-carrito', [CartController::class, 'procesarPagoCarrito']);

    Route::post('/validar-descuento', [CartController::class, 'validarDescuento'])->name('discount.validate');
});

require __DIR__.'/auth.php';

require __DIR__.'/english.php';

require __DIR__.'/admin.php';
