<?php

use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Auth\ConfirmablePasswordController;
use App\Http\Controllers\Auth\EmailVerificationNotificationController;
use App\Http\Controllers\Auth\EmailVerificationPromptController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Auth\VerifyEmailController;
use Illuminate\Support\Facades\Route;

Route::get('/register', [RegisteredUserController::class, 'create'])
                ->middleware('guest')
                ->name('register');

Route::post('/register', [RegisteredUserController::class, 'store'])
                ->middleware('guest');

Route::get('/registroAnfitriones', [RegisteredUserController::class, 'previoRegistro']);

// Stepper  anfitriones fisicos GET
Route::get('/registroAnfitriones/paso1', [RegisteredUserController::class, 'createAnfitriones']);
Route::get('/registroAnfitriones/paso2', [RegisteredUserController::class, 'createAnfitrionesPaso2'])->name('registro-anfitriones-fisico.paso-2');
Route::get('/registroAnfitriones/paso3', [RegisteredUserController::class, 'createAnfitrionesPaso3'])->name('registro-anfitriones-fisico.paso-3');
Route::get('/registroAnfitriones/paso4', [RegisteredUserController::class, 'createAnfitrionesPaso4'])->name('registro-anfitriones-fisico.paso-4');
Route::get('/registroAnfitriones/paso5', [RegisteredUserController::class, 'createAnfitrionesPaso5'])->name('registro-anfitriones-fisico.paso-5');
Route::get('/registroAnfitriones/fin', [RegisteredUserController::class, 'createAnfitrionesSucess'])->name('registro-anfitriones-fisico.fin');


// Stepper anfitriones fisicos POST
Route::post('/registro-anfitriones-fisico/paso1', [RegisteredUserController::class, 'storeAnfitrionesFisicosStep1'])->name('store-anfitriones-fisico.paso-1');
Route::post('/registro-anfitriones-fisico/paso2', [RegisteredUserController::class, 'storeAnfitrionesFisicosStep2'])->name('store-anfitriones-fisico.paso-2');
Route::post('/registro-anfitriones-fisico/paso3', [RegisteredUserController::class, 'storeAnfitrionesFisicosStep3'])->name('store-anfitriones-fisico.paso-3');
Route::post('/registro-anfitriones-fisico/paso4', [RegisteredUserController::class, 'storeAnfitrionesFisicosStep4'])->name('store-anfitriones-fisico.paso-4');
Route::post('/registro-anfitriones-fisico/paso5', [RegisteredUserController::class, 'storeAnfitrionesFisicosStep5'])->name('store-anfitriones-fisico.paso-5');

// Stepper  anfitriones juridicos GET


// Stepper anfitriones juridicos POST
Route::post('/registro-anfitriones-juridico/paso2', [RegisteredUserController::class, 'createAnfitrionesJuridicoStep2'])->name('registro-anfitriones-juridico.paso-2');

Route::post('/registroAnfitriones', [RegisteredUserController::class, 'storeAnfitriones']);

Route::get('/login', [AuthenticatedSessionController::class, 'create'])
                ->middleware('guest')
                ->name('login');

Route::post('/login', [AuthenticatedSessionController::class, 'store'])
                ->middleware('guest');

Route::get('/forgot-password', [PasswordResetLinkController::class, 'create'])
                ->middleware('guest')
                ->name('password.request');

Route::post('/forgot-password', [PasswordResetLinkController::class, 'store'])
                ->middleware('guest')
                ->name('password.email');

Route::get('/reset-password/{token}', [NewPasswordController::class, 'create'])
                ->middleware('guest')
                ->name('password.reset');

Route::post('/create-new-password', [NewPasswordController::class, 'store'])
                ->middleware('guest')
                ->name('new-password');

Route::get('/verify-email', [EmailVerificationPromptController::class, '__invoke'])
                ->middleware('auth')
                ->name('verification.notice');

Route::get('/verify-email/{id}/{hash}', [VerifyEmailController::class, '__invoke'])
                ->middleware(['auth', 'signed', 'throttle:6,1'])
                ->name('verification.verify');

Route::post('/email/verification-notification', [EmailVerificationNotificationController::class, 'store'])
                ->middleware(['auth', 'throttle:6,1'])
                ->name('verification.send');

Route::get('/confirm-password', [ConfirmablePasswordController::class, 'show'])
                ->middleware('auth')
                ->name('password.confirm');

Route::post('/confirm-password', [ConfirmablePasswordController::class, 'store'])
                ->middleware('auth');

Route::get('/logout', [AuthenticatedSessionController::class, 'destroy'])
                ->middleware('auth')
                ->name('logout');
