<?php

use App\Http\Controllers\AdminBusquedasController;
use App\Http\Controllers\AdminCalificationsController;
use App\Http\Controllers\AdminCategoriasController;
use App\Http\Controllers\AdminEnviosRetirosController;
use App\Http\Controllers\AdministrationController;
use App\Http\Controllers\AdminExperienciasController;
use App\Http\Controllers\AdminPreguntasController;
use App\Http\Controllers\AdminVentasController;
use App\Http\Controllers\AdminPlaceController;
use App\Http\Controllers\AdminCodigoController;
use App\Http\Controllers\AdminUsersController;
use App\Http\Controllers\AdminConfiguracionesController;
use App\Http\Controllers\AdminContactosController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware'=>'auth'], function (){

    Route::get('/admin', [AdministrationController::class, 'home'])->name('admin.home');
    Route::get('/admin/profile', [AdministrationController::class, 'home'])->name('admin.profile');

    Route::get('/usuarios', [AdministrationController::class, 'getUsers'])->name('admin.users');
    Route::post('/usuarios/validar', [AdministrationController::class, 'validateUser'])->name('admin.user.validate');
    Route::get('/usuarios/borrados', [AdministrationController::class, 'getDeletedUsers'])->name('admin.users.deleted');;
    Route::get('/usuarios/editar/{id}', [AdministrationController::class, 'editAll'])->name('admin.user.all.edit');
    Route::put('/usuarios/editar/save', [AdministrationController::class, 'saveEdit']);
    Route::get('/clientes', [AdministrationController::class, 'getClients']);
    Route::get('/anfitriones', [AdministrationController::class, 'getAnfitriones'])->name('admin.anfitriones.index');
    Route::get('/anfitriones/editar/{user}', [AdministrationController::class, 'edit'])->name('admin.users.edit');

    Route::get('/nuevo-anfitrion', [AdministrationController::class, 'createAnfitrion'])->name('admin.users.create');
    Route::post('/nuevo-anfitrion', [AdministrationController::class, 'storeAnfitrion'])->name('admin.users.store');
    Route::put('/anfitriones/{user}/update', [AdministrationController::class, 'update'])->name('admin.users.update');

    Route::get('/experiencias', [AdminExperienciasController::class, 'getExperiencias'])->name('experiencias');
    Route::get('/experiencias-activas', [AdminExperienciasController::class, 'getExperienciasActivas']);
    Route::get('/experiencias-pendientes', [AdminExperienciasController::class, 'getExperienciasPendientes'])->name('experiencias.softdeleted');
    Route::get('/experiencias-destacadas', [AdminExperienciasController::class, 'getExperienciasDestacadas']);
    Route::get('/nueva-experiencia', [AdminExperienciasController::class, 'crearNueva']);
    Route::get('/experiencias/editar/{experiencia}', [AdminExperienciasController::class, 'edit'])->name('experiencias.edit');
    Route::post('/nueva-experiencia', [AdminExperienciasController::class, 'guardarNueva']);

    Route::post('/experiencias/delete/{experiencia}', [AdminExperienciasController::class, 'delete'])->name('experiencias.delete');
    Route::post('/experiencias/restore', [AdminExperienciasController::class, 'restore'])->name('experiencias.restore');
    Route::post('/experiencias/forcedelete', [AdminExperienciasController::class, 'forceDelete'])->name('experiencias.forcedelete');
    Route::put('/experiencias/{experiencia}/update', [AdminExperienciasController::class, 'update'])->name('experiencias.update');
    Route::post('/experiencias/activate', [AdminExperienciasController::class, 'activate'])->name('experiencias.activate');

    //categorias
    Route::get('/categorias', [AdminCategoriasController::class, 'categorias']);
    Route::get('/crear-categoria', [AdminCategoriasController::class, 'createCategoria']);
    Route::post('/store-categoria', [AdminCategoriasController::class, 'storeCategoria']);
    Route::get('/edit-categoria/{id}', [AdminCategoriasController::class, 'editCategoria']);
    Route::post('/update-categoria', [AdminCategoriasController::class, 'updateCategoria']);
    Route::delete('/borrar-categoria', [AdminCategoriasController::class, 'deleteCategoria']);
    Route::post('/baja-categoria', [AdminCategoriasController::class, 'dropDownCategory']);
    Route::post('/activar-categoria', [AdminCategoriasController::class, 'activeCategory']);

    //lotes de codigos
    Route::get('/codigos', [AdminCodigoController::class, 'codigos']);
    Route::get('/lotes', [AdminCodigoController::class, 'lotes']);
    Route::get('/crear-lote', [AdminCodigoController::class, 'crearLote']);
    Route::get('/crear-codigo', [AdminCodigoController::class, 'createCodigo']);
    Route::post('/crear-lote', [AdminCodigoController::class, 'storeLote']);
    Route::post('/crear-codigo', [AdminCodigoController::class, 'storeCodigo']);
    Route::delete('/borrar-codigo', [AdminCodigoController::class, 'deleteCodigo'])->name('codigo_delete');


    Route::get('/codigos-de-descuento-monto', [AdminCodigoController::class, 'descuentosPorMonto']);
    Route::get('/crear-codigo-monto', [AdminCodigoController::class, 'createCodigoPorMonto']);
    Route::post('/guardar-codigo-monto', [AdminCodigoController::class, 'storeCodigoPorMonto']);
    Route::post('/eliminar-codigo-monto', [AdminCodigoController::class, 'deleteCodigoPorMonto']);


    Route::get('/codigos-del-lote/{id}', [AdminCodigoController::class, 'codigosDelLote']);

    Route::post('/exportar-lote', [AdminCodigoController::class, 'exportLote']);

    Route::get('/cargar-excel-externo', [AdminCodigoController::class, 'createCodigoExcel'])->name('excel.cargar');
    Route::post('/cargar-excel-externo/resultados', [AdminCodigoController::class, 'readCodigoExcel'])->name('excel.result');


    Route::get('/ventas', [AdminVentasController::class, 'getVentas'])->name('venta.index');
    Route::get('/ventas/experiencias-realizadas', [AdminVentasController::class, 'getExperienciasRealizadas'])->name('venta.experiencias.index');
    Route::get('/ventas-sin-reserva', [AdminVentasController::class, 'getVentasSinReserva']);
    Route::get('/ventas-con-reserva', [AdminVentasController::class, 'getVentasConReserva']);
    Route::get('/ventas-canje', [AdminVentasController::class, 'getVentasDeCanje']);

    Route::post('/ventas/delete/{venta}', [AdminVentasController::class, 'delete'])->name('venta.delete');

    Route::get('/lugares', [AdminPlaceController::class, 'getPlaces'])->name('admin.places');
    Route::get('/lugares/edit/{place}', [AdminPlaceController::class, 'edit'])->name('admin.places.edit');
    Route::get('/lugares/borrados', [AdminPlaceController::class, 'getDeletedPlaces'])->name('admin.places.deleted');
    Route::get('/nuevo-lugar', [AdminPlaceController::class, 'create']);

    Route::put('/lugares/update/{place}', [AdminPlaceController::class, 'update'])->name('admin.places.updated');
    Route::post('/nuevo-lugar', [AdminPlaceController::class, 'store']);
    Route::post('/lugares/delete', [AdminPlaceController::class, 'deletePlace'])->name('place.delete');
    Route::post('/lugares/restore', [AdminPlaceController::class, 'restorePlace'])->name('place.restore');
    Route::post('/lugares/{place}/softdelete', [AdminPlaceController::class, 'softdeletePlace'])->name('place.softdelete');

    Route::post('/usuarios/{user}/softdelete', [AdministrationController::class, 'softdeleteUser'])->name('user.softdelete');
    Route::post('/usuarios/{user}/delete', [AdministrationController::class, 'deleteUser'])->name('user.delete');
    Route::post('/usuarios/{user}/restore', [AdministrationController::class, 'restoreUser'])->name('user.restore');

    //exportes
    Route::get('/exportar-clientes', [AdminUsersController::class, 'exportarClientes']);
    Route::get('/exportar-anfitriones', [AdminUsersController::class, 'exportarAnfitriones']);
    Route::get('/exportar-ventas', [AdminVentasController::class, 'exportarVentas']);

    //pickup/envios
    Route::get('/retiros', [AdminEnviosRetirosController::class, 'retiros'])->name('retiros.index');
    Route::get('/envios', [AdminEnviosRetirosController::class, 'envios'])->name('envios.index');
    Route::post('/retiro-completado', [AdminEnviosRetirosController::class, 'completarRetiro']);
    Route::post('/envio-completado', [AdminEnviosRetirosController::class, 'completarEnvio']);

    Route::get('/retiros/create/', [AdminEnviosRetirosController::class, 'create'])->name('pickup.create');
    Route::post('/retiros/delete/{pickUp}', [AdminEnviosRetirosController::class, 'delete'])->name('pickup.delete');
    Route::post('/envios/delete/{envio}', [AdminEnviosRetirosController::class, 'delete_envio'])->name('envio.delete');

    //contactos
    Route::get('/contactos', [AdminContactosController::class, 'getContactos']);
    Route::get('/contactos-empresas', [AdminContactosController::class, 'getContactosEmpresas']);
    Route::post('/delete-contact', [AdminContactosController::class, 'deleteContact']);


    //busqueda
    Route::post('/busqueda-admin', [AdminBusquedasController::class, 'busquedaUsuarios']);

    //configuraciones
    Route::get('/configuraciones', [AdminConfiguracionesController::class, 'index']);
    Route::post('/configurar-costo-envio', [AdminConfiguracionesController::class, 'guardarGastosEnvio']);
    Route::post('/nueva-integracion', [AdminConfiguracionesController::class, 'nuevaIntegracion']);
    Route::post('/cargar-mercado-pago', [AdminConfiguracionesController::class, 'guardarMercadoPago']);
    Route::post('/cargar-stripe', [AdminConfiguracionesController::class, 'guardarStripe']);
    Route::post('/cargar-correo-electronico', [AdminConfiguracionesController::class, 'guardarEmail']);

    //preguntas
    Route::get('/ver-preguntas', [AdminPreguntasController::class, 'getPreguntas']);
    Route::post('/responderPregunta', [AdminPreguntasController::class, 'responderPregunta']);
    Route::delete('/borrarPregunta', [AdminPreguntasController::class, 'borrarPregunta']);

    //calificaciones
    Route::get('/califications', [AdminCalificationsController::class, 'getCalifications']);
    Route::post('/saveCalification', [AdminCalificationsController::class, 'saveCalification']);
    Route::delete('/borrarCalification', [AdminCalificationsController::class, 'deleteCalificacion']);

    //busqueda
    Route::post('/search-anfitriones', [AdminBusquedasController::class, 'buscarAnfitrion']);
});
