@extends('layouts.app')

@section('styles')
<style>
    .btn-danger{
        color: white !important;
    }
    .btn-primary{
        color: white !important;
        margin-bottom: 2rem;
    }
    .card-title{
        margin-top: 1rem;
    }
</style>
@endsection
<head>
    <link type="text/css" rel="stylesheet" href="{{ asset('css/image-uploader.css') }}">
</head>
@section('contenido')

    <section id="generica">
        <div class="container">
            @include('components.profile-header', ['user'=>$user])
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h2 class="mb-1 mt-5">Bienvenido, {{ $user->name }}</h2>
                    <hr/>
                </div>
            </div>
            <br><br>
            <div class="row justify-content-center align-items-center pb-2">
                <div class="col-sm-12 text-center ftco-animate botones text-black fadeInUp ftco-animated" id="facebook">
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Mis compras</h5>
                                <p class="card-text">Desde esta sección podrá ingresar a sus compras, experiencias regaladas o códigos de canje.</p>
                                <a href="{{ url('/compras') }}" class="btn btn-primary">Compras</a>
                            </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Experiencias Regaladas</h5>
                                <p class="card-text">Si desea ver las experiencias regaladas a amigos y familiares, puede hacer click debajo.</p>
                                <a href="{{ url('/experiencias-regaladas') }}" class="btn btn-primary">Regalos</a>
                            </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Perfil</h5>
                                <p class="card-text">Para ver o modificar sus datos personales, o verificar su cuenta, haga click en la parte inferior.</p>
                                <a href="{{ url('/perfil') }}" class="btn btn-primary">Perfil</a>
                            </div>
                            </div>
                        </div>
                    </div>
                    <br><br>
                    <div class="row justify-content-center">
                        <div class="col-sm-4">
                            <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Favoritos</h5>
                                <p class="card-text">Desde esta sección podrá ver sus experiencias marcadas como favoritas.</p>
                                <a href="{{ url('/mis-favoritos') }}" class="btn btn-primary">Favoritos</a>
                            </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Abrir Regalo</h5>
                                <p class="card-text">Si tenes un código de regalo YeAh!, ingresa acá para abrirlo y canjearlo.</p>
                                <a href="{{ url('/abrir-regalo') }}" class="btn btn-primary">Códigos</a>
                            </div>
                            </div>
                        </div>
                        @if($user->role_id === 3)
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title">Mis experiencias</h5>
                                    <p class="card-text">Desde aquí podrás ver tus experiencias activas, crear nuevas o editarlas</p>
                                    <a href="{{ url('/mis-experiencias') }}" class="btn btn-primary">Experiencias</a>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                    @if($user->role_id === 3)
                        <br><br>
                        <div class="row justify-content-center">
                            <div class="col-sm-4">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">Redimir códigos</h5>
                                        <p class="card-text">Desde esta sección podrá verificar si los códigos de YeAh! son válidos.</p>
                                        <a href="{{ url('/redimir-codigo') }}" class="btn btn-primary">Redimir Código</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">Mis Ventas</h5>
                                        <p class="card-text">Para ver las ventas que posee, ingrese con el botón que se encuentra debajo.</p>
                                        <a href="{{ url('/mis-ventas') }}" class="btn btn-primary">Mis ventas</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">Crear experiencias</h5>
                                        <p class="card-text">Si desea crear nuevas experiencias, puede hacerlo desde esta sección.</p>
                                        <a href="{{ url('/crear-experiencia') }}" class="btn btn-primary">Crear Experiencia</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>

<script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
<script type="text/javascript" src="{{ asset('js/image-uploader.js') }}"></script>

<script>

</script>
@endsection
