@extends('layouts.app')

@section('contenido')

    <!-- SECCIÓN Mis Compras -->
    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container-fluid">
            @include('components.profile-header', ['user'=>$user])
        </div>
        <div class="container-fluid">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Mis Experiencias Regaladas</h3>
                    <hr/>
                </div>
            </div>
            <div class="row pb-2">
                <div class="col-md-12 mb-5 ">
                    <div class="container-fluid">
                        <div class="row align-items-left">
                            <div class="col-md-12">
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                        <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                            <thead class="thead-dark">
                                            <tr>
                                                <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                                <th class="encabezadoTabla">Experiencia</th>
                                                <th class="encabezadoTabla">Anfitrión</th>
                                                <th class="encabezadoTabla">Código</th>

                                                <th class="encabezadoTabla">Ubicación</th>
                                                <th class="encabezadoTabla">Ciudad</th>
                                                <th class="encabezadoTabla">Teléfono anfitrión</th>

                                                <th class="encabezadoTabla">Estado</th>
                                                <th class="encabezadoTabla">Vencimiento</th>
                                                <th class="encabezadoTabla" style="width: 10%">Compartir</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($regalos as $regalo)
                                                <tr>
                                                    <td><img style="width: 100%" src="{{ asset('storage/experiencias/'.$experiencia->picture) }}"></td>
                                                    <td><a href="{{ url('/experiencia') . '/' . $regalo->experiencia->id }}">{{ $regalo->experiencia->title }}</a></td>
                                                    <td>{{ $regalo->experiencia->user->user_details->fake_name }}</td>
                                                    <td><strong>{{ $regalo->code }}</strong></td>
                                                    <td>{{ $regalo->experiencia->location }}</td>
                                                    <td>{{ $regalo->experiencia->city }}</td>
                                                    <td>{{ $regalo->experiencia->user->user_details->reservation_phone }}</td>
                                                    <td>{{ $regalo->used == 0 ? "No usado" : "Utilizado" }}</td>
                                                    <td></td>
                                                    <td style="text-align: center;">
                                                        <a href='https://api.whatsapp.com/send?text=Hola,%20te%20hice%20un%20regalo%20en%20Yeah!%20Para%20verlo,
                                                            %20ingresa%20con%20tu%20cuenta%20a%20www.yeah.com.ar/abrir-regalo/%20y%20colocá%20el
                                                            %20siguiente%20código:%20{{ $regalo->code }}%20Que%20lo%20disfrutes!' target='_blank'>
                                                            <span><img src='{{ asset('/imgs/whatsapp_off.svg') }}' style="width: 50%;"></span>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- col-md-12 -->
                        </div><!-- row -->
                    </div><!-- container -->
                </div>
            </div>
        </div><!-- container -->
    </section>


@endsection
