@extends('layouts.app')

@section('contenido')

    <!-- SECCIÓN Mis Compras -->
    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container-fluid">
            @include('components.profile-header', ['user'=>$user])
        </div>
        <div class="container-fluid">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Mis Reservas</h3>
                    <hr/>
                </div>
            </div>
            <div class="row pb-2">
                <div class="col-md-12 mb-5 ">
                    <div class="container-fluid">
                        <div class="row align-items-left">
                            <div class="col-md-12">
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                        <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                            <thead class="thead-dark">
                                            <tr>
                                                <th class="encabezadoTabla" style="width: 10%;">Foto</th>
                                                <th class="encabezadoTabla">Experiencia</th>
                                                <th class="encabezadoTabla">Anfitrión</th>

                                                <th class="encabezadoTabla">Ubicación</th>
                                                <th class="encabezadoTabla">Ciudad</th>
                                                <th class="encabezadoTabla">Teléfono (Solo reservas)</th>
                                                <th class="encabezadoTabla">Teléfono anfitrión</th>

                                                <th class="encabezadoTabla">Estado</th>
                                                <th class="encabezadoTabla">Fecha de reserva</th>
                                                <th class="encabezadoTabla">Fecha de emision</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($reservas as $reserva)
                                                <tr>
                                                    <td><img style="width: 100%" src="{{ asset('storage/experiencias/'.$experiencia->picture) }}"></td>
                                                    <td><a href="{{ url('/experiencia-detalles/').'/'.$reserva->experiencia->id }}"> {{ $reserva->experiencia->title }} </a></td>
                                                    <td>{{ $reserva->experiencia->user->user_details->fake_name }}</td>
                                                    <td>{{ $reserva->experiencia->location }}</td>
                                                    <td>{{ $reserva->experiencia->city }}</td>
                                                    <td>{{ $reserva->experiencia->reservations_phone }}</td>
                                                    <td>{{ $reserva->experiencia->user->user_details->reservation_phone }}</td>
                                                    <td>{{ $reserva->used == 0 ? "No Realizada" : "Realizada" }}</td>
                                                    <td style="{{ \Carbon\Carbon::parse($reserva->reserva)->format('d-m-Y') >= \Carbon\Carbon::now()  ? 'color: #ffc107;font-weight: bold' : ''}}">{{ \Carbon\Carbon::parse($reserva->reserva)->format('d-m-Y H:m') }}</td>
                                                    <td>{{ $reserva->created_at->format('d/m/Y') }}</td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- col-md-12 -->
                        </div><!-- row -->
                    </div><!-- container -->
                </div>
            </div>
        </div><!-- container -->
    </section>


@endsection
