@extends('layouts.app')

@section('contenido')

<!-- SECCIÓN Mis Compras -->
<section class="ftco-section no-gutters mb-2" id="generica">
    <div class="container-fluid">
        @include('components.profile-header', ['user'=>$user])
    </div>
    <div class="container-fluid">
        <div class="row pb-2">
            <div class="col-sm-12 mb-5 text-center">
                <h3 class="mt-5">Mis Códigos Canjeables</h3>
                <hr/>
            </div>
        </div>
        <div class="row pb-2">
            <div class="col-md-12 mb-5">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                    <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                        <thead class="thead-dark">
                                        <tr>
                                            <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                            <th class="encabezadoTabla">Experiencia</th>
                                            <th class="encabezadoTabla">Código</th>
                                            <th class="encabezadoTabla">Anfitrión</th>
                                            <th class="encabezadoTabla">Teléfono (Reservas)</th>
                                            <th class="encabezadoTabla">Email</th>
                                            <th class="encabezadoTabla">Monto</th>
                                            <th class="encabezadoTabla">Fecha Compra</th>
                                            <th class="encabezadoTabla">Estado Compra</th>
                                            <th class="encabezadoTabla">Vencimiento</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($codigos as $codigo)
                                                <tr style="text-align: center">
                                                    <td><img style="width: 100%" src="{{ asset('storage/experiencias/'.$experiencia->picture) }}"></td>
                                                    <td><a href="{{ url('/experiencia-detalles/').'/'.$codigo->experiencia->id }}"> {{ $codigo->experiencia->title }} </a></td>
                                                    <td style="font-weight: bold; color: #c29300">{{$codigo->code}}</td>
                                                    <td>{{ $codigo->experiencia->user->user_details != null ? $codigo->experiencia->user->user_details->fake_name : '-'   }}</td>
                                                    <td>{{ $codigo->experiencia->user->user_details != null ? $codigo->experiencia->user->user_details->reservation_phone : "-" }}</td>
                                                    <td>{{ $codigo->experiencia->user->email }}</td>
                                                    <td>${{ $codigo->experiencia->final_price }}</td>
                                                    <td>{{  Carbon\Carbon::parse($codigo->created_at)->format('d-m-Y') }}</td>
                                                    <td>{{ $codigo->venta->approved == 0 ? "Desaprobada" : "Aprobada" }}</td>
                                                    <td>@if($codigo->code) {{ date('d-m-Y', strtotime($codigo->date_exp)) }} @else - @endif</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div>
        </div>
    </div><!-- container -->
</section>


@endsection
