@extends('layouts.app')

@section('contenido')

    <!-- SECCIÓN Mis Compras -->
    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container-fluid">
            @include('components.profile-header', ['user'=>$user])
        </div>
        <div class="container-fluid">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Mis Favoritos</h3>
                    <hr/>
                </div>
            </div>
            <div class="row pb-2">
                <div class="col-md-12 mb-5 ">
                    <div class="container-fluid">
                        <div class="row align-items-left">
                            <div class="col-md-12">
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                        <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                            <thead class="thead-dark">
                                            <tr>
                                                <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                                <th class="encabezadoTabla">Experiencia</th>
                                                <th class="encabezadoTabla">Anfitrión</th>
                                                <th class="encabezadoTabla">Precio</th>
                                                <th class="encabezadoTabla">Disponible</th>
                                                <th class="encabezadoTabla">Quitar de favoritos</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($favoritos as $favorito)
                                                <tr>
                                                    <td><img style="width: 100%" src="{{ asset('storage/experiencias/'.$experiencia->picture) }}"></td>
                                                    <td><a href="{{ url('/experiencia/') . "/" . $favorito->experiencia->id }}">{{ $favorito->experiencia->title }}</a></td>
                                                    <td>{{ $favorito->experiencia->user->user_details->fake_name }}</td>
                                                    <td>$ {{ $favorito->experiencia->price }}</td>
                                                    <td>{{ $favorito->experiencia->valid == 1 ? "Si" : "No" }}</td>
                                                    <td style="text-align: center"><a href="{{ url('/experiencia/quitar-favorito') ."/". $favorito->experiencia->id }}"><i class="fas fa-trash"></i></a></td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- col-md-12 -->
                        </div><!-- row -->
                    </div><!-- container -->
                </div>
            </div>
        </div><!-- container -->
    </section>


@endsection
