@extends('layouts.app')

@section('contenido')

    <!-- SECCIÓN Mis Compras -->
    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container">
            @include('components.profile-header', ['user'=>$user])
        </div>
        <div class="container">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Mis dudas</h3>
                    <hr/>
                </div>
            </div>
            <div class="row pb-2">
                <div class="col-md-12 mb-5 ">
                    <div class="container-fluid">
                        <div class="row align-items-left">
                            <div class="col-md-12">
                                <div class="tab-content" id="myTabContent">
                                    <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                        <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                            <thead class="thead-dark">
                                            <tr>
                                                <th class="encabezadoTabla">Pregunta</th>
                                                <th class="encabezadoTabla">Respuesta</th>
                                                <th class="encabezadoTabla">Experiencia</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($preguntas as $pregunta)
                                                <tr>

                                                    <td>{{ $pregunta->pregunta }}</td>
                                                    <td>{{ $pregunta->respuesta != null ? $pregunta->respuesta : "-" }}</td>
                                                    <td>{{ $pregunta->experiencia->title }}</td>

                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- col-md-12 -->
                        </div><!-- row -->
                    </div><!-- container -->
                </div>
            </div>
        </div><!-- container -->
    </section>


@endsection
