@extends('layouts.app')

@section('contenido')

<!-- SECCIÓN Mis Compras -->
<section class="ftco-section no-gutters mb-2" id="generica">
    <div class="container-fluid">
        @include('components.profile-header', ['user'=>$user])
    </div>
    <div class="container-fluid">
        <div class="row pb-2">
            <div class="col-sm-12 mb-5 text-center">
                <h3 class="mt-5">Canjes de Puntos</h3>
                <hr/>
            </div>
        </div>
        <div class="row pb-2 text-center">
            <div class="col-9 col-md-9 col-xl-9 m-auto">
                <p class="text-center m-auto">Desde esta sección puede ver todas las experiencias recibidas por el canje de puntos desde LatamPass, Banco Patagonia, y más.</p>
                <p class="text-center m-auto">Para utilizar estas experiencias, <strong>comunicate con el anfitrión, y llevale el código de la experiencia,</strong> para coordinar día y horario.</p>
            </div>
        </div>
        <br>
        <div class="row pb-2">
            <div class="col-md-12 mb-5 ">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">

                                    <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                        <thead class="thead-dark">
                                        <tr>
                                            <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                            <th class="encabezadoTabla">Experiencia</th>
                                            <th class="encabezadoTabla">Código</th>
                                            <th class="encabezadoTabla">Anfitrión</th>
                                            <th class="encabezadoTabla">Teléfono (Reservas)</th>
                                            <th class="encabezadoTabla">Email</th>
                                            <th class="encabezadoTabla">Fecha Compra</th>
                                            <th class="encabezadoTabla">Vencimiento</th>
                                            <th></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($compras as $compra)
                                                <tr style="text-align: center">
                                                    <td><img style="width: 100%" src="{{ asset('storage/experiencias/'.$compra->experiencia->picture) }}"></td>
                                                    <td><a href="{{ url('/experiencia-detalles/').'/'.$compra->experiencia->id }}"> {{ $compra->experiencia->title }} </a></td>
                                                    <td style="font-weight: bold; color: #c29300">@if($compra->codigoCanjeable) {{$compra->codigoCanjeable->code}} @else - @endif</td>
                                                    <td>{{ $compra->experiencia->user->user_details != null ? $compra->experiencia->user->user_details->fake_name : '-'   }}</td>
                                                    <td>{{ $compra->experiencia->user->user_details != null ? $compra->experiencia->user->user_details->reservation_phone : "-" }}</td>
                                                    <td>{{ $compra->experiencia->user->email }}</td>
                                                    <td>{{  Carbon\Carbon::parse($compra->created_at)->format('d-m-Y') }}</td>
                                                    <td>@if($compra->codigoCanjeable) {{ date('d-m-Y', strtotime($compra->codigoCanjeable->date_exp)) }} @else - @endif</td>
                                                    <td style="text-align: center;">
                                                        <a title="Regalar código (Podes regalar este código a alguien para que lo utilice si así lo deseas)"
                                                           href='https://api.whatsapp.com/send?text=Hola,%20te%20hice%20un%20regalo%20en%20Yeah!%20
                                                            Para%20utilizarlo,%20comunicate%20con%20{{ $compra->experiencia->user->user_details->fake_name }}
                                                               %20al%20{{ $compra->experiencia->user->user_details->reservation_phone }},%20o%20por%20mail
                                                               %20a%20{{ $compra->experiencia->user->email }},%20arregla%20un%20día%20y%20horario,%20y%20llevale%20el%20
                                                               código:%20{{ $compra->codigoCanjeable->code }}%20¡Que%20lo%20disfrutes!' target='_blank'>
                                                            <img style="width: 20% !important" src='{{ asset('/imgs/whatsapp_off.svg') }}'>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div>
        </div>
    </div><!-- container -->
</section>


@endsection
