@extends('layouts.app')

@section('contenido')
    @if(!isset($error))
        <div class="container">
        <h3>¡¡¡Abriste tu regalo correctamente!!!</h3>
        <br /><br />
            <div class='card' style='padding: 15px;'>
                <h3>¡Tu experiencia {{ $codigo_canjeable->experiencia->title }} te espera!</h3>
                <br />
                <div class='card-body'>
                    <img src="/storage/experiencias/{{ $codigo_canjeable->experiencia->picture }}" class='card-img-top' alt=''>
                    <h4 class='card-title'>{{ $codigo_canjeable->experiencia->title }}</h4>
                    <p class='card-text'>{{ $codigo_canjeable->experiencia->description }}</p>
                    <p>¡Recuerda que tienes hasta el {{ $codigo_canjeable->date_exp }} para utilizarlo!</p>
                    <br>
                    <h4>Detalles del anfitrión:</h4>

                    <section class="ftco-section border-top-amarillo" id="ficha-anfitrion">
                        <div class="container px-4">
                            <div class="row">
                                <div class="col-md-4 col-lg-4 p-0">
                                    <div class="anfitriones d-flex">
                                        <div class="row no-gutters">
                                            <div class="col-12">
                                                <h3>Anfitrión</h3>
                                            </div>
                                            <div class="col-12 d-flex">
                                                <div class="anfitrion-img img">
                                                    <span><img src="{{ asset('imgs/svgs/ico-grupo.svg') }}"></span>
                                                </div>
                                                <div class="text">
                                                    <p>{{ $codigo_canjeable->experiencia->user->user_details->fake_name }}</p>
                                                    <p></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- anfitriones -->
                                </div><!-- col-md-4 -->

                                <div class="col-md-4 col-lg-4 p-0">
                                    <div class="anfitriones d-flex">
                                        <div class="row no-gutters">
                                            <div class="col-12">
                                                <h3>Locación</h3>
                                            </div>
                                            <div class="col-12 d-flex">
                                                <div class="anfitrion-img img">
                                                    <span><img src="{{ asset('imgs/svgs/ico-locacion.svg') }}"></span>
                                                </div>
                                                <div class="text">
                                                    <p>{{ $codigo_canjeable->experiencia->location }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- anfitriones -->
                                </div><!-- col-md-4 -->

                                <div class="col-md-4 col-lg-4 p-0">
                                    <div class="anfitriones tercero d-flex">
                                        <div class="row no-gutters">
                                            <div class="col-12">
                                                <h3>Teléfono</h3>
                                            </div>
                                            <div class="col-12 d-flex">
                                                <div class="anfitrion-img img">
                                                    <a href="https://wa.me/{{ $codigo_canjeable->experiencia->user->user_details->reservation_phone }}"
                                                       target="_blank"><span><img src="{{ asset('imgs/svgs/whatsapp_off.svg') }}"></span></a>
                                                </div>
                                                <div class="text">
                                                    <p>{{ $codigo_canjeable->experiencia->user->user_details->reservation_phone }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- anfitriones -->
                                </div><!-- col-md-4 -->

                                <div class="col-md-4 col-lg-4 p-0">
                                    <div class="anfitriones inferior d-flex">
                                        <div class="row no-gutters">
                                            <div class="col-12">
                                                <h3>Incluye</h3>
                                            </div>
                                            <div class="col-12 d-flex">
                                                <div class="anfitrion-img img">
                                                    <span><img src="{{ asset('imgs/svgs/ico-check.svg') }}"></span>
                                                </div>
                                                <div class="text">
                                                    <p>{{ $codigo_canjeable->experiencia->includes }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- anfitriones -->
                                </div><!-- col-md-4 -->

                                <div class="col-md-4 col-lg-4 p-0">
                                    <div class="anfitriones inferior d-flex">
                                        <div class="row no-gutters">
                                            <div class="col-12">
                                                <h3>Idiomas</h3>
                                            </div>
                                            <div class="col-12 d-flex">
                                                <div class="anfitrion-img img">
                                                    <span><img src="{{ asset('imgs/svgs/ico-idiomas.svg') }}"></span>
                                                </div>
                                                <div class="text">
                                                    <p>{{ $codigo_canjeable->experiencia->languajes }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- anfitriones -->
                                </div><!-- col-md-4 -->

                                <div class="col-md-4 col-lg-4 p-0">
                                    <div class="anfitriones inferior tercero d-flex">
                                        <div class="row no-gutters">
                                            <div class="col-12">
                                                <h3>¿Qué llevar?</h3>
                                            </div>
                                            <div class="col-12 d-flex">
                                                <div class="anfitrion-img img">
                                                    <span><img src="{{ asset('imgs/svgs/ico-requisitos.svg') }}"></span>
                                                </div>
                                                <div class="text">
                                                    <p>{{ $codigo_canjeable->experiencia->what_bring }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
                <br />
                <div class="col-6">
                    <h4>Ir a mis regalos:</h4>
                    <a href="{{ url('/regalos-abiertos') }}" class="btn btn-secondary">Regalos Recibidos</a>
                </div>
            </div>
        </div>
    @else
        <div class="container">
            <h3>Ups, no se encontró el código</h3>
            <br /><br />
            <p>Parece que el código ingresado no pudo encontrarse.
            Intenta copiar nuevamente el código de regalo, o comunicate
            con Yeah! si pensas que puede deberse a un error.</p>
            <br />
            <a href="{{ url('/abrir-regalo') }}">Volver</a>
        </div>
    @endif
@endsection
