@extends('layouts.app')

<style>
    .tyc{
        color: black;
        text-decoration: underline;
        font-weight: bold;
    }
    .mercadopago-button{
        margin-top: 0px !important;
        margin-bottom: 0px !important;
    }
</style>
@section('contenido')
    <!-- SECCIÓN BLANCA DE BODY -->
    <section id="reservar" class="pagar justify-content-center align-items-center">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <h2 class="mb-1 mt-5">Revisar y pagar</h2>
                    <hr/>
                </div>
            </div>
            <div class="row mt-5">
                <!--columna 1-->
                <div class="col-lg-5">
                    <h5 class="mt-3 mb-3">Método de pago</h5>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="meotodopago" id="meotodopago" value="mp" checked>
                        <label class="form-check-label" for="meotodopago">
                            <img src="{{ asset('/imgs/mercado-pago.png') }}" class="logoMP">
                        </label>
                    </div>
                    <h5 class="mt-5 mb-2">Anfitrión</h5>
                    <div class="row  align-items-center">
                        <div class="col-sm-2">
                            <img src="{{ asset('/storage/anfitriones/'.$experiencia->user->picture) }}" class="img-fluid">
                        </div>
                        <div class="col-sm-10">
                            <p><a href="" class="text">{{ $experiencia->user->user_details->fake_name }}</a></p>
                        </div>
                    </div>
                    <p class="mt-5"><small>Al confirmar esta reserva aceptas la
                            <a href="terminos_y_condiciones#Exencion-responsabilidad" class="text">
                                Exención y renuncia de responsabilidad de los huéspedes</a>, y la
                            <a href="terminos_y_condiciones#reserva-reprogramacion-experiencias" class="text">Política de cancelación</a> y
                            <a href="terminos_y_condiciones#politica-de-reembolso-usuario" class="text"> la Política de reembolso al huésped.</a></small>
                    </p>
                </div>

                <!--columna 2-->
                <div class="col-lg-5 offset-lg-1 gray">
                    <h2 class="mb-1 mt-3 text-center">{{ $experiencia->title }}</h2>
                    <hr class="negro">

                    <br>
                    <div class="row">
                        <div class="col-sm-9"><h5>Vale por un participante</h5></div>
                        <div class="col-sm-3">

                        </div>
                    </div>
                    <div class="row align-items-center line-down">
                        <div class="col-sm-1 text-align-center">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="col-sm-10">
                            <h6>Locación: {{ $experiencia->location }}, {{ $experiencia->city }}, {{ $experiencia->province }}</h6>
                        </div>
                    </div>

                    <div class="row align-items-center line-down">
                        <div class="col-sm-1 text-align-center">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="col-sm-10">
                            <h6>Duración: {{ $experiencia->hours }} Horas</h6>
                        </div>
                    </div>
                    <div class="row align-items-center line-down">
                        <div class="col-sm-1 text-align-center">
                            <i class="fas fa-paint-brush"></i>
                        </div>
                        <div class="col-sm-10">
                            <h6>Incluye: {{ $experiencia->includes }}</h6>
                        </div>
                    </div>

                    <div class="row dark-gray">
                        <div class="col-sm-8">
                            <h5>Valor de la experiencia</h5>
                        </div>
                        <div class="col-sm-4">

                            <h3>$ {{ $experiencia->final_price }}</h3>
                        </div>
                    </div>

                    @if(isset($precio_envio_postal))
                        @if($precio_envio_postal != 0)
                        <div class="row dark-gray">
                            <div class="col-sm-8">
                                <h5>Valor del envío postal</h5>
                            </div>
                            <div class="col-sm-4">
                                <h3>$ {{ $precio_envio_postal }}</h3>
                            </div>
                        </div>
                        @endif
                    @endif

                    <div class="row dark-gray">
                        <div class="col-sm-8">
                            <h3>Total a Pagar</h3>
                        </div>
                        <div class="col-sm-4">
                            <h2 id="costoTotal">$ {{ $total }}</h2>
                        </div>
                    </div>
                    <div class="row dark-gray">
                        <div class="col-sm-12 text-center">
                            <div class="form-check aceptatyc_Compra">
                                Al hacer click en pagar, confirma que acepta los
                                <a class="tyc" href="terminos_y_condiciones">
                                    Términos y Condiciones
                                </a> de Yeah!
                            </div>
                        </div>
                    </div>
                    <div class="row dark-gray justify-content-sm-center">
                        <div class="col-sm-10 text-center ">
                            <div class="cho-container">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script src="https://sdk.mercadopago.com/js/v2"></script>

    <script>
        // Agrega credenciales de SDK
        const mp = new MercadoPago("{{ config('services.mercadopago.key') }}", {
            locale: 'es-AR'
        });

        // Inicializa el checkout
        mp.checkout({
            preference: {
                id: '{{ $preference->id }}'
            },
            render: {
                container: '.cho-container', // Indica el nombre de la clase donde se mostrará el botón de pago
                label: 'Aceptar y Pagar', // Cambia el texto del botón de pago (opcional)
            }
        });
    </script>

@endsection
