@extends('layouts.app')
<style>
    .tyc{
        color: black;
        text-decoration: underline;
        font-weight: bold;
    }
    .mercadopago-button{
        margin-top: 0px !important;
        margin-bottom: 0px !important;
    }
    .color-gray
    {
        color: gray;
    }
</style>
@section('contenido')
<!-- SECCIÓN BLANCA DE BODY -->
<section id="reservar" class="pagar justify-content-center align-items-center">
    <div class="container">
        
        <div id="formPagar">
            <div class="row mt-5">
                <!--columna 1-->
                <div class="col-lg-5">
                    <div class="row">
                        <div class="col-sm-12">
                            <h2 class="mb-1">Revisar y pagar</h2>
                            <hr/>
                        </div>
                    </div>
                    <h5 class="mt-3 mb-3">Método de pago</h5>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="meotodopago" id="meotodopago" value="mp" checked>
                        <label class="form-check-label" for="meotodopago">
                            <img src="{{ asset('/imgs/mercado-pago.png') }}" class="logoMP">
                        </label>
                    </div>
                    <h5 class="mt-5 mb-2">Anfitrión</h5>
                    <div class="row  align-items-center">
                        <div class="col-sm-2">
                            <img src="{{ asset('/storage/anfitriones/'.$experiencia->user->picture) }}" class="img-fluid">
                        </div>
                        <div class="col-sm-10">
                            <p class="text"><strong>{{ $experiencia->user->user_details ? $experiencia->user->user_details->fake_name : '' }}</strong></p>
                        </div>
                    </div>
                    <p class="mt-5"><small>Al confirmar esta reserva aceptas la
                    <a href="terminos_y_condiciones#Exencion-responsabilidad" class="text">
                    Exención y renuncia de responsabilidad de los huéspedes</a>, y la
                    <a href="terminos_y_condiciones#reserva-reprogramacion-experiencias" class="text">Política de cancelación</a> y
                    <a href="terminos_y_condiciones#politica-de-reembolso-usuario" class="text"> la Política de reembolso al huésped.</a></small>
                    </p>
                    <section class="dark-gray">
                            @if($errors->any())
                                <p  class="alert alert-danger" >{{$errors->first()}}</p>
                            @endif
                            @if (isset($code))
                                <p  class="alert alert-success" >{{ $success }}</p>
                            @endif
                            <h6 class="mt-3 mb-3" style="text-align: center">Tenes un codigo de descuento? Ingresalo aca!</h6>
                            @if (isset($code))
                            <div style="display: flex;gap:0.5rem;justify-content: center">
                                <input disabled style="background-color: transparent;border: none;border-bottom: 1px solid black;display: block;width: 50%" type="text" value="{{ $code }}">
                                <button type="button" style="font-size: 0.875em;border: 0px;background: #009ee3;border-radius: 0.2857142857142857em;color: #fff;">Validado</button>
                            </div>

                            @else
                                <form autocomplete="off" action="{{ route('discount.validate') }}" method="post">
                                    <div style="display: flex;gap:0.5rem;justify-content: center">
                                        @csrf
                                        <input style="background-color: transparent;border: none;border-bottom: 1px solid black;display: block;width: 50%" type="text" name="code_discount" id="code_discount">
                                        <input type="hidden" name="experience_id" value="{{ $experiencia->id }}">
                                        <button style="font-size: 0.875em;border: 0px;background: #009ee3;border-radius: 0.2857142857142857em;color: #fff;">Validar</button>
                                    </div>
                                </form>
                            @endif
                    </section>
                    <p class="mt-5 text-center dark-gray">Al terminar de abonar en Mercado Pago, hace click en 'Volver al sitio' para ver el código de tu compra y poder utilizarlo.</p>
                    <br>
                    <!--div>
                        <form action="{{ url('/experiencia/'.$experiencia->id.'/pagar') }}">
                            <label for="discount">Cupones y códigos de descuento</label>
                            <input type="text"
                                   class="form-control"
                                   placeholder="Ingrese su cupón de descuento"
                                   name="discount" required />

                            <button type="submit" class="btn btn-dark">Enviar</button>
                            @if(isset($discount))
                                <p class="color-gray mt-3">Lo sentimos, el código ingresado no tiene descuentos asociados.</p>
                            @endif
                        </form>
                    </div-->
                </div>

                <!--columna 2-->
                <div class="col-lg-5 offset-lg-1 " style="border: solid 1px lightgray;">
                    <h2 class="mb-1 mt-3 text-center">{{ $experiencia->title }}</h2>
                    <hr class="negro">

                    <br>
                  
                    
                    <h5 class="text-center">Vale por un participante</h5>
                     
                
                    <p class="text-center"><small>Podés añadir amigos a esta experiencia y confirmar tu reserva.</small></p>

                    <div class="row align-items-center line-down">
                        <div class="col-sm-1 text-align-center">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="col-sm-10">
                            <h6>Locación: {{ $experiencia->location }}, {{ $experiencia->city }}, {{ $experiencia->province }}</h6>
                        </div>
                    </div>

                    <div class="row align-items-center line-down">
                        <div class="col-sm-1 text-align-center">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="col-sm-10">
                            <h6>Duración: {{ $experiencia->duracion }}</h6>
                        </div>
                    </div>

                    <!--                 <div class="row align-items-center line-down">
                                        <div class="col-sm-11 offset-sm-1">
                                            <h6>Miércoles 20 de Junio</h6>
                                        </div>
                                    </div> -->

                    <!-- <div class="row align-items-center line-down">
                        <div class="col-sm-1 text-align-center">
                            <i class="fas fa-paint-brush"></i>
                        </div>
                        <div class="col-sm-10">
                            <h6>De 10:00 a 13:00 hs</h6>
                        </div>
                    </div> -->

                    <div class="row align-items-center line-down">
                        <div class="col-sm-1 text-align-center">
                            <i class="fas fa-paint-brush"></i>
                        </div>
                        <div class="col-sm-10">
                            <h6>Incluye: {{ $experiencia->includes }}</h6>
                        </div>
                    </div>

                    <div class="row dark-gray">
                        <div class="col-sm-8">
                            <h5>Valor de la experiencia</h5>
                        </div>
                        <div class="col-sm-4">

                            <h4>$ {{ $experiencia->final_price }}</h4>
                        </div>
                        @if (isset($code))
                        <div class="col-sm-8">
                            <h5>Descuento aplicado</h5>
                        </div>
                        <div class="col-sm-4">
                            <h5 style="color: #155724">$ {{ $experiencia->final_price-$total }}</h5>
                        </div>
                        @endif
                    </div>

                    <div class="row dark-gray">
                        <div class="col-sm-8">
                            <h3>Total a Pagar</h3>
                        </div>
                        <div class="col-sm-4">
                            <h4 id="costoTotal">$ {{ $total }}</h4>
                        </div>
                    </div>
                    <div class="row dark-gray">
                        <div class="col-sm-12 text-center">
                            <div class="form-check aceptatyc_Compra">
                                Al hacer click en pagar, confirma que acepta los
                                <a class="tyc" href="terminos_y_condiciones">
                                    Términos y Condiciones
                                </a> de Yeah!
                            </div>
                        </div>
                    </div>
                    <div class="row dark-gray justify-content-sm-center">
                        <div class="col-sm-10 text-center ">
                            <div class="cho-container">

                            </div>
                            <!--p><button type="submit" class="btn btn-secondary btn-lg btn-block cho-container">Confirmar y pagar</button></p-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://sdk.mercadopago.com/js/v2"></script>

<script>
    const mp = new MercadoPago("{{ config('services.mercadopago.key') }}", {
        locale: 'es-AR'
    });

    mp.checkout({
        preference: {
            id: '{{ $preference->id }}',
            
        },
        render: {
            container: '.cho-container',
            label: 'Aceptar y Pagar',
        }
    });
</script>

@endsection
