@extends('layouts.app')
<head>
    <style>
        .parrafo{
            word-break: normal;
        }
        .hidden{
            display: none;
        }
        @media screen and (max-width: 700px) {
            .container-experiencias{
                margin-top: 0px !important;
            }
        }
    </style>
</head>

@section('contenido')
<!-- SECCIÓN ELEGÍ CATEGORÍA -->
<section class="ftco-section titularSeccion conpeltop">

@if(count($experiencias)>0)

    <div class="container">
        <div class="row justify-content-start">
            <div class="col-md-12">
                <div class="heading-section mb-5 mt-5 text-center">
                    <h3 class="mb-2">Experiencias de {{ $anfitrion->user_details->fake_name }}</h3>
                    <div class="zigzag"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-experiencias">

        @foreach($experiencias as $experiencia)

        <div class="itemExpeCate grey-card">
            <a href="{{ url('/experiencia') . '/' . $experiencia->id }}">
                <img src="{{ asset('storage/experiencias/'.$experiencia->picture) }}" alt="{{ $experiencia->title }}" class="img200px">
            </a>
            <div class="contenidoExpeCate float-right">
                <div class="head-car">
                    <p class="category-exp"> Categoria:
                        {{ $experiencia->categories->first() != null ? $experiencia->categories->first()->title : "-" }}
                    </p>
                </div>
                <a href="{{ url('/experiencia') . '/' . $experiencia->id }}">
                    <h4 class="title-exp">{{ $experiencia->title }}</h4>
                </a>
                <p><strong> Lugar: {{ $experiencia->province }}, {{ $experiencia->city }}</strong></p><br>
                <div class="parrafo">{!! Str::limit($experiencia->description, 400, '...') !!}</div>
                <div class="price-container">
                    <div class="price-exp">$ {{ $experiencia->final_price }}</div>
                    <a href="{{ url('/experiencia') . '/' . $experiencia->id }}" id="ver-mas-yellow">Ver más</a>
                </div>
            </div>
        </div>
        @endforeach

        <div class="d-flex justify-content-center" style="padding-bottom: 10px;">
            {{ $experiencias->links() }}
        </div>
    </div>
    <div id="map"></div>


@else
<h1 class="text-center">No se encontraron resultados.</h1>
@endif
</section>


{{--
<script>
    var mapaExpe;
    var center;

    @if(count($experiencias)>0)

            var initLat = <?=$latLong[0]?>;
            var initLng = <?=$latLong[1]?>;
            var infowindow;
            var locations = [
                    <?PHP
                    foreach($experiencias as $expe) {
                    ?>
                    ['<?= $expe['titulo']; ?>', <?= $expe['coordenadas']; ?>, <?= $expe['ID']; ?>],
                    <?PHP
                    }
                    ?>
            ];

            function initMapCat() {
                infowindow = new google.maps.InfoWindow();
                center = new google.maps.LatLng(initLat, initLng);
                mapaExpe = new google.maps.Map(document.getElementById('map'), {
                    zoom: 12,
                    center: center
                });
                var marker, i;

                for (i = 0; i < locations.length; i++) {
                    marker = new google.maps.Marker({
                        position: new google.maps.LatLng(locations[i][1], locations[i][2]),
                        icon:"<?=$base;?>images/markerMap.png",
                        map: mapaExpe
                    });

                    google.maps.event.addListener(marker, 'click', (function(marker, i) {
                        return function() {
                            infowindow.setContent(locations[i][0]);
                            infowindow.open(map, marker);
                        }
                    })(marker, i));
                }

                var bounds = new google.maps.LatLngBounds ();
                for (i = 0; i < locations.length; i++) {
                    bounds.extend (new google.maps.LatLng(locations[i][1], locations[i][2]));
                }
                mapaExpe.fitBounds (bounds);

            }
    @endif
</script>
--}}
@endsection
