
@extends(( str_contains(Request::path(),'/en') ? 'en.layouts.app' : 'layouts.app' ))

<style>
    #minuevoModal {
        display: none;
        position: fixed;
        z-index: 1;
        padding-top: 100px;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgb(0,0,0);
        background-color: rgba(0,0,0,0.4);
    }

    #modal-content {
        background-color: #fefefe;
        margin: auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
    }

    #close {
        color: #aaaaaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
    }

    #close:hover,
    #close:focus {
        color: #000;
        text-decoration: none;
        cursor: pointer;
    }

    .ver-mas{
        padding: 5px;
        font-weight: bold;
    }
    .ver-mas:hover{
        text-decoration: underline;
    }

    .modal {
        display: none;
        position: fixed;
        z-index: 1;
        padding-top: 100px;
        left: 0;
        top: 0 !important;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgb(0,0,0);
        background-color: rgba(0,0,0,0.4);
    }

    .modal-content {
        background-color: #fefefe;
        margin: auto;
        padding: 20px;
        border: 1px solid #888;
        width: 80%;
    }

    .close {
        color: #aaaaaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
    }

    .close:hover,
    .close:focus {
        color: #000;
        text-decoration: none;
        cursor: pointer;
    }

    .btn-secondary{
        padding: 10px;
        font-weight: bold;
    }

    .titulo{
        text-align: left;
    }
    .header-anfitrion{
        margin-top: 0px !important;
    }
    #full-width-carousel{
        padding-right: 0px;
    }
    #full-width-carousel2{
        padding-left: 0px;
    }
    #height-80-viewport{
        height: 80vh;
    }
    .carousel-inner {
        height: 100% !important;
        padding-top: 0px !important;
    }
    .carousel-control-prev-icon, .carousel-control-next-icon {
        display: none !important;
    }
    #btn-more-expe{
        background-color: #fce913;
        border: none;
        margin-left: 20px;
        color: black;
        font-weight: 600;
        font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        font-size: 14px;
        letter-spacing: 0px;
    }

    #button_open_reviews{
        background-color: #fce913;
        border: none;
        margin-top: 1rem;
        margin-left: 20px;
        color: black;
        font-weight: 600;
        font-family: Helvetica Neue, Helvetica, Arial, sans-serif;
        font-size: 14px;
        letter-spacing: 0px;
    }
</style>
<script>
    {{--
    var latiExp = {{ $coordenates[0] }} ;
    var longExp = {{ $coordenates[1] }} ;
    //AIzaSyDdE_cW8DoghfFalUUrV28sMB2DS1s4T0k
    let map;

    function initMap() {
        map = new google.maps.Map(document.getElementById("map"), {
            center: { lat: latiExp, lng: longExp },
            zoom: 16,
        });
    }
    --}}
</script>

@section('contenido')
    <section class="header-anfitrion js-fullheight" id="height-80-viewport">
        <div class="interaccion">
            <div class="social-icons" >
                <a href="#" class="float-left abrirModalShare" id="social_share"><i class="fa fa-share"></i></a>
                <a href="#" class="float-left agregarLikes" data-exid="{{--  --}}">
                    <i class="fa fa-heart"></i>
                </a>

            </div>
        </div>

        <div class="row">
            <div class="col-md-8 col-lg-8">
                <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                    <div class="carousel-inner">

                        <div class="carousel-item active">
                            <img src="{{ asset('storage/experiencias/'.$experiencia->picture) }}" class="d-block w-100" alt="...">
                        </div>
                        @foreach($experiencia->images as $img)
                            <div class="carousel-item">
                                <img src="{{ asset('storage/experiencias/'. $img->url_image) }}" class="d-block w-100" alt="{{ $img->url_image }}">
                            </div>
                        @endforeach
                    </div>
                    <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
                        <i class="fas fa-angle-left fa-5x"></i>
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="sr-only">Previous</span>

                    </a>
                    <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
                        <i class="fas fa-angle-right fa-5x"></i>
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>

            <div class="col-md-4 col-lg-4" id="full-width-carousel2">
                <div class="intro-taller">
                    <div class="container">
                        <div class="row slider-text justify-content-end align-items-left">
                            <div class="col-12 justify-content-end principal-taller">
                                <!-- <span class="estado aprobada">Estado: Aprobada</span> -->

                                @if(str_contains(Request::path(),'/en'))

                                <h1>{{ $experiencia->title_en }}</h1>
                                <div class="zigzag"></div>
                                <br>

                                <p> {!! Str::limit($experiencia->description_en, 370, '...') !!} </p>
                                <br>
                                <p class="titulo">Final Price <strong>${{ $experiencia->price }}</strong></p>
                                <br>
                                <a href="#" id="myBtn" class="float-left ver-mas" style="margin-bottom:15px">More about the experience</a>
                                <br>

                                <p class="valor"></p>
                                <br>
                                <p><a style="padding: 5%; font-size: 18px;" id="comprarButton" href="#" class="btn btn-secondary btn-sm mt-2 btn-comprar">Buy</a></p>
                                <br>
                                <a href="#" id="miModal" class="float-left ver-mas" style="margin-bottom:15px">More about the host</a>

                                @else

                                <h1>{{ $experiencia->title }}</h1>
                                <div class="zigzag"></div>
                                <br>
                                <p> {!! Str::limit($experiencia->description, 400, '...') !!} </p>
                                <br>
                                {{-- Estrellas de la experiencia --}}
                                @php
                                    $total_stars=0;
                                    $numerber_of_reviews=count($experiencia->califications);
                                @endphp
                                @forelse ($experiencia->califications as $calification)
                                    @php
                                        $total_stars=$total_stars+$calification->stars;
                                    @endphp
                                     @if($loop->last)
                                     @switch(ceil($total_stars/$numerber_of_reviews))
                                        @case(1)
                                        <div class='puntaje'>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-off'></span>
                                            <span class='estrella-off'></span>
                                            <span class='estrella-off'></span>
                                            <span class='estrella-off'></span>
                                        </div>
                                        @break
                                        @case(2)
                                        <div class='puntaje'>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-off'></span>
                                            <span class='estrella-off'></span>
                                            <span class='estrella-off'></span>
                                        </div>
                                        @break
                                        @case(3)
                                        <div class='puntaje'>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-off'></span>
                                            <span class='estrella-off'></span>
                                        </div>
                                        @break
                                        @case(4)
                                        <div class='puntaje'>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-off'></span>
                                        </div>
                                        @break
                                        @case(5)<div class='puntaje'>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span>
                                            <span class='estrella-on'></span> </div>
                                        @break

                                         @default
                                        <div class='puntaje'>resultado: {{ $total_stars/$numerber_of_reviews }} </div>
                                     @endswitch
                                    @endif
                                @empty
                                <p style="font-weight: bolder"> <small> No hay suficientes calificaciones aun </small></p>
                                @endforelse
                                {{--Fin Estrellas de la experiencia --}}
                                <p class="titulo">Precio final <strong>${{ $experiencia->final_price }}</strong></p>
                                <br>
                                <a href="#" id="myBtn" class="float-left ver-mas" style="margin-bottom:15px">Más sobre la experiencia</a>
                                <br>

                                <p class="valor"></p>
                                <br>
                                <p><a style="padding: 5%; font-size: 18px;" id="comprarButton" href="#" class="btn btn-secondary btn-sm mt-2 btn-comprar">Comprar</a></p>
                                <br>
                                <br>
                                <p><a href="#" id="miModal" class="float-left ver-mas" style="margin-bottom:15px">Más sobre el anfitrión</a></p>
                                <p><a href="{{ url('/mas-experiencias') . '/' . $experiencia->user->id }}" class="float-left ver-mas" style="margin-bottom:15px">Más experiencias del anfitrión</a></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div><!-- row -->

    </section>
    <!-- End header-anfitrion -->
    <!-- El Modal con la descripcion de la experiencia -->
    <div id="myModal" class="modal">

        <!-- contenido -->
        <div class="modal-content">
            <span class="close">&times;</span>
        @if(str_contains(Request::path(),'/en'))
            <h1>{{ $experiencia->title_en }}</h1>
            <p>{!! $experiencia->description_en !!}</p>
        @else
            <h1>{{ $experiencia->title }}</h1>
            <p>{!! $experiencia->description !!}</p>
        @endif
        </div>

    </div>


    <!-- El Modal con la descripcion del anfitrion -->
    <div id="minuevoModal" class="modal">
        @if(str_contains(Request::path(),'/en'))
        <div id="modal-content">
            <span id="close">&times;</span>
            <h1>About the Host:</h1>
            <p>{{ $experiencia->user->user_details ? $experiencia->user->user_details->more_information  : "Nothing"}}</p>
        </div>
    </div>
    <section class="ftco-section border-top-amarillo" id="ficha-anfitrion">
        <div class="container px-4">
            <div class="row">
                <div class="col-md-4 col-lg-4 p-0">
                    <div class="anfitriones d-flex">
                        <div class="row no-gutters">
                            <div class="col-12">
                                <h3>Host</h3>
                            </div>
                            <div class="col-12 d-flex">
                                <div class="anfitrion-img img">
                                    <span><img src="{{ asset('/svgs/ico-grupo.svg') }}"></span>
                                </div>
                                <div class="text">
                                    <p>{{ $experiencia->user->user_details ? $experiencia->user->user_details->fake_name : "nada" }}</p>
                                </div>
                            </div>
                        </div>
                    </div><!-- anfitriones -->
                </div><!-- col-md-4 -->

                <div class="col-md-4 col-lg-4 p-0">
                    <div class="anfitriones d-flex">
                        <div class="row no-gutters">
                            <div class="col-12">
                                <h3>Location</h3>
                            </div>
                            <div class="col-12 d-flex">
                                <div class="anfitrion-img img">
                                    <span><img src="{{ asset('/svgs/ico-locacion.svg') }}"></span>
                                </div>
                                <div class="text">
                                    <p>{{ $experiencia->city }}, {{ $experiencia->province }}</p>
                                </div>
                            </div>
                        </div>
                    </div><!-- anfitriones -->
                </div><!-- col-md-4 -->

                <div class="col-md-4 col-lg-4 p-0">
                    <div class="anfitriones tercero d-flex">
                        <div class="row no-gutters">
                            <div class="col-12">
                                <h3>Schedule</h3>
                            </div>
                            <div class="col-12 d-flex">
                                <div class="anfitrion-img img">
                                    <span><img src="{{ asset('/svgs/ico-duracion.svg') }}"></span>
                                </div>
                                <div class="text">
                                    <p>{{ $experiencia->hours }}</p>
                                </div>
                            </div>
                        </div>
                    </div><!-- anfitriones -->
                </div><!-- col-md-4 -->

                <div class="col-md-4 col-lg-4 p-0">
                    <div class="anfitriones inferior d-flex">
                        <div class="row no-gutters">
                            <div class="col-12">
                                <h3>Includes</h3>
                            </div>
                            <div class="col-12 d-flex">
                                <div class="anfitrion-img img">
                                    <span><img src="{{ asset('/svgs/ico-check.svg') }}"></span>
                                </div>
                                <div class="text">
                                    <p>{{ $experiencia->includes }}</p>
                                </div>
                            </div>
                        </div>
                    </div><!-- anfitriones -->
                </div><!-- col-md-4 -->

                <div class="col-md-4 col-lg-4 p-0">
                    <div class="anfitriones inferior d-flex">
                        <div class="row no-gutters">
                            <div class="col-12">
                                <h3>Languajes</h3>
                            </div>
                            <div class="col-12 d-flex">
                                <div class="anfitrion-img img">
                                    <span><img src="{{ asset('/svgs/ico-idiomas.svg') }}"></span>
                                </div>
                                <div class="text">
                                    <p>Available on {{ $experiencia->languajes }}</p>
                                </div>
                            </div>
                        </div>
                    </div><!-- anfitriones -->
                </div><!-- col-md-4 -->

                <div class="col-md-4 col-lg-4 p-0">
                    <div class="anfitriones inferior tercero d-flex">
                        <div class="row no-gutters">
                            <div class="col-12">
                                <h3>Things you will need?</h3>
                            </div>
                            <div class="col-12 d-flex">
                                <div class="anfitrion-img img">
                                    <span><img src="{{ asset('/svgs/ico-requisitos.svg') }}"></span>
                                </div>
                                <div class="text">
                                    <p>{{ $experiencia->what_bring }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @else<div id="modal-content">
        <span id="close">&times;</span>
        <h1>Sobre el anfitrión:</h1>
        <p>{{ $experiencia->user->user_details ? $experiencia->user->user_details->more_information  : "nada"}}</p>
    </div>
</div>
<section class="ftco-section border-top-amarillo" id="ficha-anfitrion">
    <div class="container px-4">
        <div class="row">
            <div class="col-md-4 col-lg-4 p-0">
                <div class="anfitriones d-flex">
                    <div class="row no-gutters">
                        <div class="col-12">
                            <h3>Anfitrion</h3>
                        </div>
                        <div class="col-12 d-flex">
                            <div class="anfitrion-img img">
                                <span><img src="{{ asset('/svgs/ico-grupo.svg') }}"></span>
                            </div>
                            <div class="text">
                                <p>{{ $experiencia->user->user_details ? $experiencia->user->user_details->fake_name : "nada" }}</p>
                            </div>
                        </div>
                    </div>
                </div><!-- anfitriones -->
            </div><!-- col-md-4 -->

            <div class="col-md-4 col-lg-4 p-0">
                <div class="anfitriones d-flex">
                    <div class="row no-gutters">
                        <div class="col-12">
                            <h3>Locación</h3>
                        </div>
                        <div class="col-12 d-flex">
                            <div class="anfitrion-img img">
                                <span><img src="{{ asset('/svgs/ico-locacion.svg') }}"></span>
                            </div>
                            <div class="text">
                                <p>{{ $experiencia->city }}, {{ $experiencia->province }}</p>
                            </div>
                        </div>
                    </div>
                </div><!-- anfitriones -->
            </div><!-- col-md-4 -->

            <div class="col-md-4 col-lg-4 p-0">
                <div class="anfitriones tercero d-flex">
                    <div class="row no-gutters">
                        <div class="col-12">
                            <h3>Horarios/Duración</h3>
                        </div>
                        <div class="col-12 d-flex">
                            <div class="anfitrion-img img">
                                <span><img src="{{ asset('/svgs/ico-duracion.svg') }}"></span>
                            </div>
                            <div class="text">
                                <p>{{ $experiencia->hours }} Horas</p>
                            </div>
                        </div>
                    </div>
                </div><!-- anfitriones -->
            </div><!-- col-md-4 -->

            <div class="col-md-4 col-lg-4 p-0">
                <div class="anfitriones inferior d-flex">
                    <div class="row no-gutters">
                        <div class="col-12">
                            <h3>Incluye</h3>
                        </div>
                        <div class="col-12 d-flex">
                            <div class="anfitrion-img img">
                                <span><img src="{{ asset('/svgs/ico-check.svg') }}"></span>
                            </div>
                            <div class="text">
                                <p>{{ $experiencia->includes }}</p>
                            </div>
                        </div>
                    </div>
                </div><!-- anfitriones -->
            </div><!-- col-md-4 -->

            <div class="col-md-4 col-lg-4 p-0">
                <div class="anfitriones inferior d-flex">
                    <div class="row no-gutters">
                        <div class="col-12">
                            <h3>Idiomas</h3>
                        </div>
                        <div class="col-12 d-flex">
                            <div class="anfitrion-img img">
                                <span><img src="{{ asset('/svgs/ico-idiomas.svg') }}"></span>
                            </div>
                            <div class="text">
                                <p>Disponible en {{ $experiencia->languajes }}</p>
                            </div>
                        </div>
                    </div>
                </div><!-- anfitriones -->
            </div><!-- col-md-4 -->

            <div class="col-md-4 col-lg-4 p-0">
                <div class="anfitriones inferior tercero d-flex">
                    <div class="row no-gutters">
                        <div class="col-12">
                            <h3>¿Qué llevar?</h3>
                        </div>
                        <div class="col-12 d-flex">
                            <div class="anfitrion-img img">
                                <span><img src="{{ asset('/svgs/ico-requisitos.svg') }}"></span>
                            </div>
                            <div class="text">
                                <p>{{ $experiencia->what_bring }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
    @endif
    @if($experiencia->video != null)
        <!-- SECCIÓN VIDEO -->
        <section class="ftco-section" id="video-experiencias">
            <div class="container">
                <div class="row justify-content-center mb-2 pb-2">
                    <div class="col-md-12">
                        {!! $experiencia->video !!}
                    </div>
                </div>
            </div>
        </section>
    @endif
    @if(str_contains(Request::path(),'/en'))
    <!-- SECCIÓN DÓNDE -->
    <section class="ftco-section" id="donde">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section">
                    <h3>Where?</h3>
                </div>
            </div>
            <br><br>
            <div class="row">
                <div class="col-md-12">
                    <div class="direccion">{{ $experiencia->city }}, {{ $experiencia->province }}</div>
                </div>
            </div>
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12">
                    {{-- Mapa de la experiencia --}}
                    {{-- <div class="map">
                    <div id="map" style="width: 100%;height: 500px;"></div>
                        <script
                            src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDdE_cW8DoghfFalUUrV28sMB2DS1s4T0k&callback=initMap&v=weekly"
                            async
                        ></script>
                    </div> --}}
                </div>
            </div>
        </div>
    </section>
    @else
    <section class="ftco-section" id="donde">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section">
                    <h3>¿Dónde?</h3>
                </div>
            </div>
            <br><br>
            <div class="row">
                <div class="col-md-12">
                    <div class="direccion">{{ $experiencia->city }}, {{ $experiencia->province }}</div>
                </div>
            </div>
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12">
                    {{-- Mapa de la experiencia --}}
                    {{-- <div class="map">
                    <div id="map" style="width: 100%;height: 500px;"></div>
                        <script
                            src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDdE_cW8DoghfFalUUrV28sMB2DS1s4T0k&callback=initMap&v=weekly"
                            async
                        ></script>
                    </div> --}}
                </div>
            </div>
            <br><br>
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section">
                    <h3>Más experiencias del anfitrión:</h3>
                </div>
            </div>
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section">
                    <a href="{{ url('/mas-experiencias') . '/' . $experiencia->user->id }}" class="btn btn-primary" id="btn-more-expe">Todas las experiencias</a>
                </div>
            </div>
        </div>
    </section>
    @endif
    @if($experiencia->extra_indications != null)
    <section class="ftco-section">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12">
                    @if(str_contains(Request::path(),'/en'))
                        <h3>Extra indications</h3>
                    @else
                        <h3>Indicaciones Extra</h3>
                    @endif
                    <br />
                    <p style="margin-left: 20px">{{ $experiencia->extra_indications }}</p>
                </div>
            </div>
        </div>
    </section>
    @endif
    <!-- Calificaciones de los usuarios -->
    <section class="ftco-section" style="padding-top: 0">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12">
                    <br>
                    @if(str_contains(Request::path(),'/en'))
                        <h3>User's feedback: </h3>
                        <button type="button" class="btn btn-primary" data-toggle="modal" id="button_open_reviews" data-target="#modal_reviews">Reviews of the experience</button>
                    @else
                        <h3>Opiniones de los usuarios: </h3>
                        <button type="button" class="btn btn-primary" data-toggle="modal" id="button_open_reviews" data-target="#modal_reviews">Opiniones de la experiencia</button>
                    @endif
                    <br/>
                </div>
            </div>
        </div>
        </div>
    </section>

    <!-- SECCIÓN DUDAS -->
    <section class="ftco-section" id="dudas">
        <div class="container">
            <div class="row justify-content-left mt-2 mb-2 pb-2">
                <div class="col-md-10 text-left heading-section ingresar-duda">
                    <form class="" action="{{ url('/preguntar') }}" method="post">
                        @csrf
                        <input type="text" name="pregunta" class="form-control mb-2 mr-sm-2" id="ingresar-duda" placeholder="ingresar duda...">
                        <input type="number" value="{{ $experiencia->id }}" name="experiencia_id" style="display:none;" hidden required />
                        <button type="submit" class="btn btn-ingresar-duda mb-2"><span class="icon-arrow-right"
                                                                                       aria-hidden="true"></span></button>
                    </form>
                </div>
            </div>
            <div class="row justify-content-left mt-2 mb-2 pb-2">
                <div class="col-md-10 text-left heading-section ingresar-duda">
                    @if(str_contains(Request::path(),'/en'))
                        <h3>Frequent questions: </h3>
                    @else
                        <h3>Dudas de los usuarios: </h3>
                    @endif
                </div>
            </div>
            <div class="row justify-content-left mt-2 mb-2 pb-2">
                @foreach($preguntas as $pregunta)
                <div class="col-md-10 text-left heading-section ingresar-duda" style="background-color: white; padding: 2%;">
                    <div style="font-style: italic"> {{ $pregunta->pregunta }} </div>
                    <br>
                    <strong>{{ $pregunta->respuesta }}</strong>
                </div>
                @endforeach
            </div>
        </div>
    </section>


    <!-- Modal RESERVAR EXPERIENCIA-->
    <div class="modal fade" id="ReservarExperiencia" tabindex="-1" role="dialog" aria-labelledby="ReservarExperiencia"
         aria-hidden="true">
        <div class="modal-dialog amarillo" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" id="closeBuyingModal" class="close" data-dismiss="modal" aria-label="Close">
                        <img src="{{ asset('svgs/close.png') }}" class="img-fluid">
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">


                        <div class="col-md-12 ftco-animate text-center mb-2">
                            @if(str_contains(Request::path(),'/en'))
                                <h2 class="text-center">¿Are you planing to gift this experiencie?</h2>
                            @else
                                <h2 class="text-center">¿Vas a regalar esta experiencia?</h2>
                            @endif
                            <div class="zigzag-blanco f-none"></div>
                        </div>
                        <div class="col-md-12 ftco-animate mt-5 mb-5">
                            <div class="blog-entry">
                                <div class="row text-center">
                                    <div class="col-sm-6 text-center">
                                        @if(str_contains(Request::path(),'/en'))
                                            <p><a href="{{ url('/experiencia') . "/"  . $experiencia->id . "/regalar"}}" class="btn btn-secondary btn-md btn-block">Yes</a></p>
                                        @else
                                            <p><a href="{{ url('/experiencia') . "/"  . $experiencia->id . "/regalar"}}" class="btn btn-secondary btn-md btn-block">Si</a></p>
                                        @endif
                                    </div>
                                    <div class="col-sm-6 text-center">
                                        @if(str_contains(Request::path(),'/en'))
                                            <p><a href="{{ url('/experiencia') . "/" . $experiencia->id . "/pagar"}}" class="btn btn-secondary btn-md btn-block">No , it's for myself</a></p>
                                        @else
                                        @endif
                                        <p><a href="{{ url('/experiencia') . "/" . $experiencia->id . "/pagar"}}" class="btn btn-secondary btn-md btn-block">Es para mi</a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- row -->
                </div>
            </div>
        </div>
    </div>

    <!-- El Modal con la descripcion de la experiencia -->
    <div id="myModal" class="modal">
        <!-- contenido -->
        <div class="modal-content justify-content-end principal-taller">
            <span class="close"></span>
            @if(str_contains(Request::path(),'/en'))
                <h1>{!! $experiencia->titulo_en !!}<h1>
                <p> {!! $experiencia->description_en !!} </p>
            @else
                <h1>{!! $experiencia->titulo !!}<h1>
                <p> {!! $experiencia->description !!} </p>
            @endif
        </div>
    </div>



    <!-- Modal para ver las opiniones -->
<div id="modal_reviews" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-lg">
    	<div class="modal-content">
		<blockquote style="margin: auto;margin-left: 20px;margin-top: 40px;" class="blockquote">
            @forelse ($califications as $calification)
			    <p><i>{{ $calification->opinion }}</i></p>
                <footer style="margin-bottom: 5%" class="blockquote-footer">{{ $calification->user->name  }}</footer>
            @empty
            <p><i>No hay opiniones aun</i></p>
            <footer style="margin-bottom: 5%" class="blockquote-footer">Animate a ser de los primeros!</footer>
            @endforelse
		</blockquote>
        </div>
    </div>
</div>
<!--Fin  Modal para ver las opiniones -->

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>

<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.2.1/js/bootstrap.min.js" integrity="sha384-B0UglyR+jN6CkvvICOB2joaf5I4l3gm9GU6Hc1og6Ls7i6U/mkkaduKaBhlAXv9k" crossorigin="anonymous"></script>
    <script>
        //Scripts para el modal de la descripcion de la experiencia
        var modal = document.getElementById("myModal");
        var btn = document.getElementById("myBtn");
        var span = document.getElementsByClassName("close")[0];

        btn.onclick = function() {
            modal.style.display = "block";
        }
        span.onclick = function() {
            modal.style.display = "none";
        }
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }


        //Scripts para el modal de la descripcion del anfitrion
        var modal2 = document.getElementById("minuevoModal");
        var boton2 = document.getElementById("miModal");
        var close2 = document.getElementById("close");

        boton2.onclick = function() {
            modal2.style.display = "block";
        }
        close2.onclick = function() {
            modal2.style.display = "none";
        }
        window.onclick = function(event) {
            if (event.target == modal2) {
                modal2.style.display = "none";
            }
        }
        </script>

    <script>
        const modalComprar = document.getElementById("ReservarExperiencia");
        const comprarButton = document.getElementById("comprarButton");
        const closeButton = document.getElementById("closeBuyingModal");

        comprarButton.addEventListener('click', function (){
            modalComprar.style.display= "block";
            modalComprar.style.opacity= 1;
        });

        closeButton.addEventListener('click', function (){
            modalComprar.style.display= "none";
            modalComprar.style.opacity= 0;
        });
    </script>

@endsection
