@extends('en.layouts.app')
<style>
    #my-custom-nav-bar{
        display: none;
    }
    #button-toggle-navigation{
        display: none;
    }
    .categoria-background{
        background-size: cover;
        background-repeat: no-repeat;
        min-height: 150px;
        max-height: 220px;
        padding: 0%;
    }
    .lugar-background{
        background-size: cover;
        background-repeat: no-repeat;
        min-height: 150px;
        max-height: 220px;
        padding: 0%;
    }
    .txt-cat{
        font-weight: 600;
    }
    .titulo-lugar{
        font-weight: 600;
    }
    .flag-container{
        display: inline;
    }
    .flags-languaje{
        display: inline;
        width: 20px;
    }

</style>
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
</head>
@section('contenido')
    <section class="experiencias js-fullheight">
        <div class="js-fullheight" style="background-image: url({{ asset('imgs/banner_01.jpg') }}); height: 100vh !important;">
            <div>
                <div class="logo-blanco"><img src="{{ asset('imgs/logo-yeah-blanco.png') }}" alt=""></div>
                @auth
                <div class="home-links-top">
                    <a href="{{ route('perfil') }}"><i class="fas fa-user"></i></a>&nbsp;|
                    <div class="flag-container">
                        <a href="{{ url('/en') }}"><img src="{{ asset('imgs/svgs/uk_flag.svg') }}" alt="" class="flags-languaje"></a>&nbsp;
                        <a href="{{ url('/es') }}"><img src="{{ asset('imgs/svgs/Bandera_de_España.svg') }}" class="flags-languaje" alt=""></a>&nbsp;
                    </div>
                </div>
                @else
                <div class="home-links-top">
                    <a href="{{ url('/login') }}" data-toggle="modal" data-target="#IniciarSesion">Log in</a> |
                    <a href="{{ url('/register') }}">Sign in</a>
                    |
                    <a href="{{ url('/en') }}"><img src="{{ asset('imgs/svgs/uk_flag.svg') }}" alt="" class="flags-languaje"></a>&nbsp;
                    <a href="{{ url('/') }}"><img src="{{ asset('imgs/svgs/Bandera_de_España.svg') }}" class="flags-languaje" alt=""></a>&nbsp;
                </div>
                @endauth
                <div class="d-block d-sm-none">
                    <div>
                        <button id="button-toggle-navigation" class="navbar-toggler navbar-top" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
								<span class="navbar-toggler-icon">
									<svg width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-list" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" d="M2.5 11.5A.5.5 0 0 1 3 11h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4A.5.5 0 0 1 3 7h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4A.5.5 0 0 1 3 3h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5z"/>
									</svg>
								</span>
                        </button>

                        <div class="collapse navbar-collapse navbar-collapse-top d-none" id="navbarSupportedContent"></div>
                        <div class="collapse navbar-collapse navbar-collapse-top" id="navbarSupportedContent">
                            <ul class="navbar-nav">
                                <li class="nav-item active">
                                    <a class="nav-link" aria-current="page" href="Login">Log in</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="Quiero_ser_anfitrion">Become host</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#">Help</a>
                                </li>
                            </ul>
                        </div>

                        <!--button class="search-top navbar-toggler" type="button" data-toggle="collapse" data-target="#searchContent" aria-controls="searchContent" aria-expanded="false" aria-label="Toggle navigation">
                            <i class="fas fa-search"></i>
                        </button-->
                        <div class="collapse navbar-collapse search-collapse-top" id="searchContent"></div>
                        <div class="collapse navbar-collapse search-collapse-top" id="searchContent">
                            <form action="Buscar/" method="POST" id="formSearchH">
                                <div class="nav-selects" id="nav-selects-container">
                                    <!--
                                    <label class="input-label">Categoria</label>
                                    -->
                                    <div   class="nav-select-wrap">
                                        <select class="nav-select" name="category">
                                            <option disabled selected hidden value="X">Categories</option>
                                                @foreach($categorias as $categoria)
                                                    <option value="{{ $categoria->id }}">{{ $categoria->title }}</option>
                                                @endforeach
                                        </select>
                                    </div>
                                    <div class="nav-select-wrap">
                                        <select class="nav-select" name="provincia">
                                            <option disabled selected hidden value="X">Provincia</option>
                                            <option value="CABA">Ciudad Autónoma de Buenos Aires</option>
                                            <option value="Buenos Aires">Buenos Aires</option>
                                            <option value="Catamarca">Catamarca</option>
                                            <option value="Chaco">Chaco</option>
                                            <option value="Chubut">Chubut</option>
                                            <option value="Córdoba">Córdoba</option>
                                            <option value="Corrientes">Corrientes</option>
                                            <option value="Entre Ríos">Entre Ríos</option>
                                            <option value="Formosa">Formosa</option>
                                            <option value="Jujuy">Jujuy</option>
                                            <option value="La Pampa">La Pampa</option>
                                            <option value="La Rioja">La Rioja</option>
                                            <option value="Mendoza">Mendoza</option>
                                            <option value="Misiones">Misiones</option>
                                            <option value="Neuquén">Neuquén</option>
                                            <option value="Río Negro">Río Negro</option>
                                            <option value="Salta">Salta</option>
                                            <option value="San Juan">San Juan</option>
                                            <option value="San Luis">San Luis</option>
                                            <option value="Santa Cruz">Santa Cruz</option>
                                            <option value="Santa Fe">Santa Fe</option>
                                            <option value="Santiago del Estero">Santiago del Estero</option>
                                            <option value="Tierra del Fuego">Tierra del Fuego</option>
                                            <option value="Tucuman">Tucuman</option>
                                        </select>
                                    </div>
                                    <div class="nav-select-wrap">
                                        <select class="nav-select" name="price">
                                            <option hidden selected value="X">Price</option>
                                            <option value="{{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }}-{{ $experiencias->sortBy('final_price')->pluck('final_price')->last() }}">From ${{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }}</option>
                                            <option value="{{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }}-{{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }}">From ${{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }} to ${{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }}</option>
                                            <option value="{{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }}-{{ $experiencias->sortBy('final_price')->pluck('final_price')->last() }}">From ${{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }} to ${{ $experiencias->sortBy('final_price')->pluck('final_price')->last() }}</option>
                                        </select>
                                    </div>
                                    <div class="nav-input-wrap">
                                        <input type="text" required class="nav-search placeholder" id="searchH" name="busqueda" placeholder="Search: spa, etc.">
                                    </div>
                                </div>

                                <div class="btn-selects-search">
                                    <button class="btn-selects-search"><div class="nav-btn-search">Search</div><span class="icon-search" id="search-nav-sticky" aria-hidden="true"></span></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row-aligned-buttons experiencias-row-buttons" id="experiencias-row-buttons">

                <div class="sad">
                    <form action="{{ route('busqueda') }}" method="POST" id="formSearchH">
                        @csrf
                        <div class="nav-selects" id="nav-selects-container">
                            <!--
                            <label class="input-label">Categoria</label>
                            -->
                            <div class="nav-select-wrap">
                                <select class="nav-select" name="category">
                                    <option disabled selected hidden value="X">Categories</option>
                                    @foreach($categorias as $categoria)
                                        <option value="{{ $categoria->id }}">{{ $categoria->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="nav-select-wrap">
                                <select class="nav-select" name="provincia">
                                    <option disabled selected hidden value="X">Provincia</option>
                                    <option value="CABA">Ciudad Autónoma de Buenos Aires</option>
                                    <option value="Buenos Aires">Buenos Aires</option>
                                    <option value="Catamarca">Catamarca</option>
                                    <option value="Chaco">Chaco</option>
                                    <option value="Chubut">Chubut</option>
                                    <option value="Córdoba">Córdoba</option>
                                    <option value="Corrientes">Corrientes</option>
                                    <option value="Entre Ríos">Entre Ríos</option>
                                    <option value="Formosa">Formosa</option>
                                    <option value="Jujuy">Jujuy</option>
                                    <option value="La Pampa">La Pampa</option>
                                    <option value="La Rioja">La Rioja</option>
                                    <option value="Mendoza">Mendoza</option>
                                    <option value="Misiones">Misiones</option>
                                    <option value="Neuquén">Neuquén</option>
                                    <option value="Río Negro">Río Negro</option>
                                    <option value="Salta">Salta</option>
                                    <option value="San Juan">San Juan</option>
                                    <option value="San Luis">San Luis</option>
                                    <option value="Santa Cruz">Santa Cruz</option>
                                    <option value="Santa Fe">Santa Fe</option>
                                    <option value="Santiago del Estero">Santiago del Estero</option>
                                    <option value="Tierra del Fuego">Tierra del Fuego</option>
                                    <option value="Tucuman">Tucuman</option>
                                </select>
                            </div>
                            <div class="nav-select-wrap">
                                <select class="nav-select" name="price">
                                            <option hidden selected value="X">Price</option>
                                            <option value="{{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }}-{{ $experiencias->sortBy('final_price')->pluck('final_price')->last() }}">From ${{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }}</option>
                                            <option value="{{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }}-{{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }}">From ${{ $experiencias->sortBy('final_price')->pluck('final_price')->first() }} to ${{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }}</option>
                                            <option value="{{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }}-{{ $experiencias->sortBy('final_price')->pluck('final_price')->last() }}">From ${{ $experiencias->sortBy('final_price')->pluck('final_price')->median() }} to ${{ $experiencias->sortBy('final_price')->pluck('final_price')->last() }}</option>
                                </select>
                            </div>
                            <div class="nav-input-wrap">
                                <input type="text" class="nav-search placeholder" id="searchH" name="busqueda" placeholder="Search: spa, etc.">
                            </div>
                            <button class="btn-selects-search">
                                <div class="nav-btn-search">Search</div>
                                <span class="icon-search" id="search-nav-sticky" aria-hidden="true"></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Fin Ajustes - Nuevo menu de items -->
            <div class="overlay"></div>
            <div class="container">
                <div class="row slider-text align-items-center" data-scrollax-parent="true">
                    <div class="col-md-12 col-sm-12 text-left ftco-animate">
                        <h4 class="cursiva subtitulo">Enjoy & share</h4>
                        <h1 class="mb-4">EXPERIENCIES</h1>
                        <p id="buttons-header">
                                <form class="p-3 px-xl-4 py-xl-3" action="{{ route('busqueda') }}" method="GET">
                                    
                                    <button  class="btn btn-primary btn-outline-primary p-3 px-xl-4 py-xl-3">Share experiencies</button>
                                    <input type="hidden" name="busqueda" value="">
                                    <a href="{{ url('/abrir-regalo') }}" class="btn btn-primary p-3 px-xl-4 py-xl-3">Open your gift</a>
                                </form>
                        </p>
                    </div>
                </div>

                <div class="row align-items-end text-left banner-items" id="empresas">
                    <div class="col-sm-3">
                        <a href="{{ route('contacto.empresa') }}" id="yellow-color"><span><img src="{{ url('imgs/briefcase.svg') }}" class="yellow"></span>
                            Companies </a>
                    </div>
                    <div class="col-sm-3">
                        <a href="{{ route('contacto') }}" id="yellow-color"><span><img src="{{ url('imgs/email.svg') }}" class="yellow"></span> Contact
                        </a>
                    </div>
                    <div class="col-sm-6">
                        <a href="{{ url('/registroAnfitriones') }}" id="yellow-color"><span><img src="{{ url('imgs/star.svg') }}" class="yellow"></span> Become Host </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- SECCIÓN ELEGÍ CATEGORÍA -->
    <section class="ftco-section ftco-wrap-about ftco-no-pb">
        <div class="container">
            <div class="row justify-content-start">
                <div class="col-md-12">
                    <div class="heading-section mb-5 mt-5 text-left">
                        <h3 class="mb-2">Choose a category</h3>
                        <div class="zigzag"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- CATEGORIAS DENTRO DEL CONTAINER -->
        <div class="container-fluid">
            <div class="row">
                @foreach($categorias as $categoria)
                    <div class="col-md-3 categoria-background" id="" style="background-image: url({{ "/storage/categorias/" . $categoria->picture }});">
                        <div class="lugar2 linkLugar img d-flex align-items-center justify-content-center">
                            <div class="content-cat">
                                <a href="{{ url('/categoria') . '/' . $categoria->id }}"><div class="content txt-cat">{{ $categoria->title }}</div></a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>


    <!-- SECCIÓN ELEGÍ EL LUGAR -->
    <section class="ftco-section" id="elegi-el-lugar">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section ftco-animate">
                    <!-- <span class="subheading">Chef</span> -->
                    <h3>Choose a place</h3>
                    <div class="zigzag"></div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                @foreach($lugares as $lugar)
                    <div class="col-md-3 lugar-background" id="lugares-home" style="background-image: url({{ "/storage/places/" . $lugar->image }});">
                        <div class="" class="lugar2 linkLugar img d-flex align-items-center justify-content-center">
                            <a href="{{ url('/lugar') . '/' . $lugar->id }}" class="lugar2 linkLugar img d-flex align-items-center justify-content-center">
                                <span class="titulo-lugar">{{ $lugar->name }}</span>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

    </section>

    <section class="ftco-section" id="destacadas">
        <div class="container">
            <div class="row justify-content-center mb-2 pb-2">
                <div class="col-md-12 text-left heading-section ftco-animate">
                    <!-- <span class="subheading">Chef</span> -->
                    <h3>Featured</h3>
                    <!-- <hr> -->
                    <div class="zigzag"></div>
                </div>
            </div>
            <div class="row">
                @foreach($experiencias as $experiencia)
                <div class="col-md-3 ftco-animate">
                    <div class="blog-entry">
                        <div class="destacadas-icons">
                            <a href="#" class="float-right meta-share abrirModalShare"><span class="icon-share"></span></a>
                            <a href="{{ url('/experiencia/favorita') .'/'. $experiencia->id }}" class="float-right meta-like agregarLikes" data-exid=""><span class="icon-heart"></span></a>
                        </div>
                        <a href="{{ route('experiencias.eng',['experiencia'=>$experiencia])}}"
                           class="block-20"
                           style="background-image: url('/storage/experiencias/{{ $experiencia->picture }}');">
                        </a>
                        <div class="text pt-3 pb-4">
                            <h3 class="heading"><a href="{{ url('/experiencia/') .'/'. $experiencia->id }}">{{ $experiencia->title_en }}</a></h3>
                            <p><small>{{ $experiencia->location }}</small></p>
                            <p>{!! Str::limit($experiencia->description_en, 200, '...') !!}</p>
                            <p class="clearfix">
                                <a href="{{ route('experiencias.eng',['experiencia'=>$experiencia])}}" class="float-left ver-mas">See more</a>
                            </p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
@section('custom-scripts')


    <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
    <script>
        $(function(){
            $('.selectpicker').selectpicker();
        });
    </script>


@endsection
