<!DOCTYPE html>
<html lang="es">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <link rel="shortcut icon" href="{{ asset('favicon.png') }}" />
        <title>Yeah! </title>
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">
        <link href="//fonts.googleapis.com/css?family=DM+Sans:400,400i,500,500i,700,700i|Dawning+of+a+New+Day|Loved+by+the+King&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous"/>
        <link rel="stylesheet" href="{{ asset('css/open-iconic-bootstrap.min.css') }}">
        <link rel="stylesheet" href="{{ asset('css/animate.css') }}">
        <link rel="stylesheet" href="{{ asset('css/all.css') }}">
        <link rel="stylesheet" href="{{ asset('css/owl.carousel.min.css') }}">
        <link rel="stylesheet" href="{{ asset('css/owl.theme.default.min.css') }}">
        <link rel="stylesheet" href="{{ asset('css/magnific-popup.css') }}">
        <!--link rel="stylesheet" href="{{ asset('css/aos.css') }}"-->
        <link rel="stylesheet" href="{{ asset('css/ionicons.min.css') }}">
        <link rel="stylesheet" href="{{ asset('css/fullcalendar.css') }}">
        <link rel="stylesheet" href="{{ asset('css/app.css') }}">

        <link rel="stylesheet" href="{{ asset('css/bootstrap-datepicker.css') }}">
        <link rel="stylesheet" href="{{ asset('css/jquery.timepicker.css') }}">

        <link rel="stylesheet" href="{{ asset('css/flaticon.css') }}">
        <link rel="stylesheet" href="{{ asset('css/icomoon.css') }}">

        <link href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
        <link rel="stylesheet" href="{{ asset('css/style.css') }}">
        <link rel="stylesheet" href="{{ asset('css/responsive.css') }}">
        <link rel="stylesheet" href="{{ asset('css/anfitrion.css') }}">
        <link rel="stylesheet" href="{{ asset('css/sectionstyle2.css') }}">

        <!--script-- src="{{ asset('js/app.js') }}" defer></script-->
        <style>
            .logo-yeah{
                width: 75%;
                margin: auto;
            }
            #navbar-brand{
                max-width: 220px;
            }
            .nav-link{
                color:  #333333 !important;
            }
            #search-nav-bar{
                display: inline;
                width: 75%;
                padding: 15px;
            }
            .botom-register-links{
                color:  #333333;
            }
            .botom-register-links:hover{
                color:  #333333;
                text-decoration: underline;
            }
            .footer-link:hover{
                text-decoration: none;
            }
            #search-button{
                padding: 0px !important;
            }
        </style>
    </head>
    <body>

    <nav class="navbar navbar-expand-lg navbar-light bg-light" id="my-custom-nav-bar">
        <a class="navbar-brand" id="navbar-brand" href="{{ url('/') }}">
            <img src="{{ asset('imgs/yeah_logo.png') }}" class="logo-yeah mx-auto d-block" alt="">
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-end" id="navbarNavAltMarkup">
            <div class="navbar-nav">
                <form action="{{ url('/busqueda') }}" method="GET">
                    
                    <input class="form-control" name="busqueda" type="search" id="search-nav-bar" placeholder="Search spa, resto, etc" aria-label="Search">
                    <button class="btn" id="search-button" type="submit"><i class="fas fa-search"></i></button>
                </form>
                @auth
                    <a class="nav-link" href="{{ url('/perfil') }}"><i class="fas fa-user"></i></a>
                @else
                    <a class="nav-link" href="{{ url('/login') }}">Log in</a>
                    <a class="nav-link" href="{{ url('/registroAnfitriones') }}">Become host</a>
                @endauth
                    <a class="nav-link" href="#">Help</a>
            </div>
        </div>
    </nav>

    @yield('contenido')

    <!-- FOOTER -->
    <footer class="ftco-footer ftco-section">
        <div class="container-fluid px-md-5 px-3">
            <div id="footera" class="row mb-5">
                <div class="col-md-4 col-lg-3 pl-5">
                    <div class="ftco-footer-widget dividir">
                        <a href="{{ route('home.eng') }}">
                            <img src="{{ asset('/imgs/yeah_logo_footer.png') }}" class="footer-logo">
                        </a>
                        <p><a href="mailto:info@yeah.com.ar" class="mail">info@yeah.com.ar</a><div class="zigzag"></div></p>
                        <p>+549-(2920)-297777</p>
                    </div>
                </div>
                <div class="col-md-4 col-lg-6 medio-sm">
                    <div class="row">
                        <div class="col-md-12 col-lg-6">
                            <div class="ftco-footer-widget">
                                <ul class="menu-footer">
                                    <li class="d-flex"><a class="footer-link" href="{{ url('/register') }}">Sign in</a></li>
                                    <li class="d-flex"><a class="footer-link" href="{{ url('/login') }}">Log in</a></li>
                                    <li class="d-flex"><a class="footer-link" href="{{ url('/registroAnfitriones') }}">Become host</a></li>
                                    <li class="d-flex"><a class="footer-link" href="{{ url('/login') }}">Login as host</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-12 col-lg-6">
                            <div class="ftco-footer-widget mb-4">
                                <ul class="menu-footer">
                                    <li class="d-flex"><a class="footer-link" href="{{ route('faqs.eng') }}">FAQS</a></li>
                                    <li class="d-flex"><a class="footer-link" href="{{ route('contacto.empresa') }}">Company</a></li>
                                    <li class="d-flex"><a class="footer-link" href="{{ route('contacto') }}">Contact us</a></li>
                                    <li class="d-flex"><a class="footer-link" href="{{ route('terms_and_conditions.eng') }}">Terms and conditions</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3">
                    <div class="ftco-footer-widget dividir ultimo">
                        <h2 class="ftco-heading-2">Follow us on:</h2>
                        <ul class="ftco-footer-social list-unstyled float-md-left float-lft mt-3">
                            <li class="ftco-animate"><a href="https://www.youtube.com/channel/UC_41ktupYsNM44ZwC2NwX2Q"><span class="icon-youtube"></span></a></li>
                            <li class="ftco-animate"><a href="https://www.facebook.com/yeah.experiencias/" target="_blank"><span class="icon-facebook"></span></a></li>
                            <li class="ftco-animate"><a href="https://www.instagram.com/yeah_experiencias/?hl=es-la" target="_blank"><span class="icon-instagram"></span></a></li>
                        </ul>
                    </div>
                </div>
            </div><!-- row -->
            <div class="row">
                <div class="col-md-12 copyright" style="text-align:center;">
                    <p>Copyright {{ \Carbon\Carbon::now()->year }} Yeah!. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>
    <script src="{{ asset('js/aos.js') }}"></script>
    <!--script src="{{ asset('js/app.js') }}"></script-->
    <script src="{{ asset('js/jquery.min.js') }}"></script>
    <script type="text/javascript">

        $('#carouselExample').on('slide.bs.carousel', function (e) {


            var $e = $(e.relatedTarget);
            var idx = $e.index();
            var itemsPerSlide = 3;
            var totalItems = $('.carousel-item').length;

            if (idx >= totalItems-(itemsPerSlide-1)) {
                var it = itemsPerSlide - (totalItems - idx);
                for (var i=0; i<it; i++) {
                    // append slides to end
                    if (e.direction=="left") {
                        $('.carousel-item').eq(i).appendTo('.carousel-inner');
                    }
                    else {
                        $('.carousel-item').eq(0).appendTo('.carousel-inner');
                    }
                }
            }
        });
        $(document).ready(function() {
            $('a.linkHomeb').click(function(e) {
                e.stopPropagation();
                console.log("#saasd");
            });

            /* show lightbox when clicking a thumbnail */
            $('a.thumb').click(function(event){
                event.preventDefault();
                var content = $('.modal-body');
                content.empty();
                var title = $(this).attr("title");
                $('.modal-title').html(title);
                content.html($(this).html());
                $(".modal-profile").modal({show:true});
            });

        });
    </script>
    <script src="{{ asset('js/owl.carousel.min.js') }}"></script>
    <script src="{{ asset('js/bootstrap-datepicker.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js" integrity="sha384-eMNCOe7tC1doHpGoWe/6oMVemdAVTMs2xqW4mwXrXsW0L84Iytr2wi5v2QjrP/xp" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.min.js" integrity="sha384-cn7l7gDp0eyniUwwAZgrzD06kc/tftFf19TOAs2zVinnD/C7E91j9yyk5//jjpt/" crossorigin="anonymous"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

    @yield('custom-scripts')
    </body>
</html>
