@extends('layouts.app')

<style>
    .tyc{
        color: black;
        text-decoration: underline;
        font-weight: bold;
    }
    .mercadopago-button{
        margin-top: 0px !important;
        margin-bottom: 0px !important;
    }
</style>
@section('contenido')


    <section id="reservar" class="pagar justify-content-center align-items-center">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <h2 class="mb-1 mt-5">Pagar tu carrito</h2>
                    <hr/>
                </div>
            </div>
            <div class="row mt-5">
                <div class="col-lg-5">
                    <div class="row">
                        <div class="col-sm-12">
                            <h4 class="mb-1 mt-5">Estas por comprar estas experiencias para ti.</h4>
                        </div>
                    </div>
                    <div class="row">
                        <!-- Expe y anfitriones. -->
                    </div>
                    <h5 class="mt-3 mb-3">Método de pago</h5>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="meotodopago" id="meotodopago" value="mp" checked>
                        <label class="form-check-label" for="meotodopago">
                            <img src="{{ asset('/imgs/mercado-pago.png') }}" class="logoMP">
                        </label>
                    </div>
                    <p class="mt-5"><small>Al confirmar esta reserva aceptas la
                            <a href="terminos_y_condiciones#Exencion-responsabilidad" class="text">
                                Exención y renuncia de responsabilidad de los huéspedes</a>, y la
                            <a href="terminos_y_condiciones#reserva-reprogramacion-experiencias" class="text">Política de cancelación</a> y
                            <a href="terminos_y_condiciones#politica-de-reembolso-usuario" class="text"> la Política de reembolso al huésped.</a></small>
                    </p>
                    {{-- <section class="dark-gray">
                        @if($errors->any())
                            <p  class="alert alert-danger" >{{$errors->first()}}</p>
                        @endif
                        @if (\Session::has('success'))
                            <p  class="alert alert-success" >{!! \Session::get('success') !!}</p>
                        @endif
                        <h6 class="mt-3 mb-3" style="text-align: center">Tenes un codigo de descuento? Ingresalo aca!</h6>
                        <form action="{{ route('discount.validate') }}" method="post">
                            <div style="display: flex;gap:0.5rem;justify-content: center">
                                @csrf
                                <input style="background-color: transparent;border: none;border-bottom: 1px solid black;display: block;width: 50%" type="text" name="code_discount">
                                <button style="font-size: 0.875em;border: 0px;background: #009ee3;border-radius: 0.2857142857142857em;color: #fff;">Validar</button>
                            </div>
                        </form>
                    </section> --}}
                    
                </div>
                <div class="col-lg-5 offset-lg-1 gray">
                    <div class="row">
                        <div class="col-9"><h4>Experiencias: </h4></div>
                    </div>
                    @foreach($experiencias as $experiencia)
                    <div class="row">
                        <div class="col-3"
                            style="max-height: 40px;overflow: hidden;">
                            <img src="/storage/experiencias/{{ $experiencia->picture }}" alt="Foto de {{ $experiencia->title }}" />
                        </div>
                        <div class="col-7">
                            <h6>{{ $experiencia->title }}</h6>
                            <p><small>{{ $experiencia->user->user_details->fake_name }}</small></p>
                        </div>
                        <div class="col-2">
                            <p>${{ $experiencia->final_price }}</p>
                        </div>
                    </div>
                    @endforeach
                    <div class="row">
                        <div class="col-12"><h4>Cantidad de experiencias: {{ count($experiencias) }}</h4></div>
                    </div>



                    <div class="row dark-gray">
                        <div class="col-sm-8">
                            <h3>Total a Pagar</h3>
                        </div>
                        <div class="col-sm-4">
                            <h3 id="costoTotal">$ {{ $total }}</h3>
                        </div>
                    </div>
                    <div class="row dark-gray">
                        <div class="col-sm-12 text-center">
                            <div class="form-check aceptatyc_Compra">
                                Al hacer click en pagar, confirma que acepta los
                                <a class="tyc" href="terminos_y_condiciones">
                                    Términos y Condiciones
                                </a> de Yeah!
                            </div>
                        </div>
                    </div>
                    <div class="row dark-gray justify-content-sm-center">
                        <div class="col-sm-10 text-center ">
                            <div class="cho-container">
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <script src="https://sdk.mercadopago.com/js/v2"></script>

    <script>
        // Agrega credenciales de SDK
        const mp = new MercadoPago("{{ config('services.mercadopago.key') }}", {
            locale: 'es-AR'
        });

        // Inicializa el checkout
        mp.checkout({
            preference: {
                id: '{{ $preference->id }}'
            },
            render: {
                container: '.cho-container',
                label: 'Aceptar y Pagar',
            }
        });
    </script>
@endsection
