@extends('layouts.app')
@section('contenido')

<style>
	#floating-panel {
  position: relative;
  top: 10px;
  left: 25%;
  z-index: 5;
  background-color: #fff;
  padding: 5px;
  text-align: left;
  font-family: "Roboto", "sans-serif";
  line-height: 30px;
  padding-left: 10px;
}
</style>
    @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
    @endif
<section id="reservar" class="anfitrion justify-content-center align-items-center">
    <div class="container">
		<form method="POST" action="{{ route('store-anfitriones-fisico.paso-3') }}">
            @csrf
            <div class="row mt-5">
                <div class="col-sm-12 justify-content-center text-center">
                    <h2 class="mb-1 mt-5">Creá tu primer experiencia</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="col-md-6 offset-md-3 justify-content-center text-center">
                        <p class="bajada">Estás a un paso de convertirte en anfitrión/a.</p>
                    </div>
                </div>
                <!--columna 1-->
                <div class="col-md-5 mt-2 text-center">
                    <!--FORMULARIO DATOS CREAR EXPERIENCIA-->
                    <h2 class="mb-1 mt-5">Ubicación de la<br>experiencia</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
					<div class="form-group">
						<label>Dirección</label>
                        <input list="place" autocomplete="off" type="text" name="place" placeholder="Ingresá la dirección" class="form-control text-descripcion" required />
					</div>


					<div class="form-group">
						<label>Provincia</label>
						<select class="form-control mt-label"  id="province" name="province">
							<option disabled selected hidden value="X">Provincia</option>
							<option value="CABA">Ciudad Autónoma de Buenos Aires</option>
							<option value="Buenos Aires">Buenos Aires</option>
							<option value="Catamarca">Catamarca</option>
							<option value="Chaco">Chaco</option>
							<option value="Chubut">Chubut</option>
							<option value="Córdoba">Córdoba</option>
							<option value="Corrientes">Corrientes</option>
							<option value="Entre Ríos">Entre Ríos</option>
							<option value="Formosa">Formosa</option>
							<option value="Jujuy">Jujuy</option>
							<option value="La Pampa">La Pampa</option>
							<option value="La Rioja">La Rioja</option>
							<option value="Mendoza">Mendoza</option>
							<option value="Misiones">Misiones</option>
							<option value="Neuquén">Neuquén</option>
							<option value="Río Negro">Río Negro</option>
							<option value="Salta">Salta</option>
							<option value="San Juan">San Juan</option>
							<option value="San Luis">San Luis</option>
							<option value="Santa Cruz">Santa Cruz</option>
							<option value="Santa Fe">Santa Fe</option>
							<option value="Santiago del Estero">Santiago del Estero</option>
							<option value="Tierra del Fuego">Tierra del Fuego</option>
							<option value="Tucuman">Tucuman</option>
						</select>
					</div>
					<div class="form-group">
						<label>Ciudad</label>
                        <input type="text" name="city" placeholder="" class="form-control mt-label" required />

					</div>
                </div>

                <!--columna 2-->
                <div class="col-md-5 offset-md-1 text-center">
                    <h2 class="mb-1 mt-5">Idioma</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>


						<label>¿Cual es el idioma que deben saber los viajeros?</label>
						<p></p><div class="zigzag pb-2 f-none"></div><p></p>

                    <!--FORMULARIO DATOS IDIOMA-->
					<div class="form-check text-left">
						<input type="checkbox" name="español" value="español" />  <label for="languajes" class="label-check">Español</label><br>
                        <input type="checkbox" name="ingles" value="ingles" />  <label for="languajes" class="label-check">Inlges</label><br>
                        <input type="checkbox" name="italiano" value="italiano" />  <label for="languajes" class="label-check">Italiano</label><br>
                        <input type="checkbox" name="portugues" value="portugues" />  <label for="languajes" class="label-check">Portugues</label><br>
                        <input type="checkbox" name="frances" value="frances" />  <label for="languajes" class="label-check">Frances</label><br>
                        <input type="checkbox" name="aleman" value="aleman" />  <label for="languajes" class="label-check">Aleman</label>
					</div>
                </div>

                <!--columna 2-->
				<div class="col-md-5" >
				<h2 class="mb-1" style="margin-top: 5rem; text-align:center;">Indicá en el mapa el punto de encuentro de tu experiencia</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="text-left">
                        <div class="form-group">
							<div class="form-group pt-4 pb-2">
									<div id="floating-panel">
										<input id="delete-markers" type="button" value="Borrar punto" />
									</div>
								 <div class="col-md-9 col-sm-8 col-xs-12 mapa" id="mapa" style="margin-top: 2rem;;width: 100%;height: 400px;border:2px solid transparent;"></div>
								 <input type="hidden" id="coordenates" name="coordenates" class="form-control" required /><br />
                            </div>
                        </div>
                    </div>
				</div>

                <div class="col-md-5 offset-md-1 text-center">

                    <h2 class="mb-1 mt-5">Elegí al menos una categoría</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <!--FORMULARIO ELEGIR CATEGORIA-->
					<div class="form-group">
						<div class="row">
							<div class="col-md-6">
								<div class="form-check text-left">
                                    @foreach($categorias as $categoria)
                                            <input type="checkbox" name="categorias[]" value="{{$categoria->id}}" />
                                            <label for="categoria_{{$categoria->id}}" class="label-check">{{$categoria->title}}</label> <br>
                                        @endforeach

								</div>
							</div>

						</div>
					</div>
                </div>

				<div class="col-md-5" >
				<h2 class="mb-1" style="margin-top: 5rem; text-align:center;">Indicaciones extra:</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="text-left">
                        <div class="form-group pb-2">
                            <textarea class="form-control "
									name="extra_indications"
									id="extra_indications"
									placeholder="Indicaciones que pueden ayudar a encontrar el lugar o a prepararse para la experiencia..."
									style="height: 160px!important;resize: none"></textarea>
                        </div>
                    </div>
				</div>

				<div class="col-md-5 offset-md-1 text-center">
                    <h2 class="mb-1 mt-5">Verificación</h2>
					<div class="form-group mt-5">
						<label>¿Es necesario que se verifique la identidad del usuario?</label>
						<p></p><div class="zigzag pb-2 f-none"></div><p></p>
					</div>
					<div class="form-check text-left">
						<input class="form-check-input" type="radio" name="require_validation_user" id="anf_reg_requiere_validacion_dni_0" value="0">
						<label class="form-check-label" for="anf_reg_requiere_validacion_dni_0"> No</label>
					</div>
					<div class="form-check text-left mb-5">
						<input class="form-check-input" type="radio" name="require_validation_user" id="anf_reg_requiere_validacion_dni_1" value="1">
						<label class="form-check-label" for="anf_reg_requiere_validacion_dni_1"> Si</label>
					</div>
				</div>

            </div>
            <div class="row mb-5 mt-5 justify-content-sm-center">
                <div class="col-sm-4 text-center ">
                    <p><button type="submit" class="btn btn-secondary btn-lg btn-block">Siguiente</button></p>
                </div>
            </div>
		</form>
    </div>
	<datalist id="place">
		@foreach ($lugares as $lugar )
			<option value="{{ $lugar->name }}">
		@endforeach
    </datalist>
</section>

<script>
		const label = "Aqui!";
		let markers = [];

		function initMap() {
		// Coordenadas de Buenos aires
		const bsas = { lat: -34.6083, lng: -58.3712 };

		const map = new google.maps.Map(document.getElementById("mapa"));
		navigator.geolocation.getCurrentPosition(function(position) {

		    // Mapa centrado en la posicion del usuario si acepta la geolocalizacion
		    var initialLocation = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
		    map.setCenter(initialLocation);
		    map.setZoom(13);
		  }, function(positionError) {
		    // User denied geolocation prompt - default Buenos Aires
		    map.setCenter(new google.maps.LatLng(bsas));
		    map.setZoom(5);
		  });

		 // This event listener calls addMarker() when the map is clicked.
		 google.maps.event.addListener(map, "click", (event) => {
			addMarker(event.latLng, map);
		});
		document.getElementById("delete-markers").addEventListener("click", deleteMarkers);
	}
		// Adds a marker to the map.
		function addMarker(location, map) {
		// Add the marker at the clicked location, and add the next-available label
		// from the array of alphabetical characters.
		const marker = new google.maps.Marker({
			position: location,
			label: label,
			map: map,
			});
			markers.push(marker);
			document.getElementById("coordenates").value = marker.position;
		}
		function setMapOnAll(map) {
			for (let i = 0; i < markers.length; i++) {
				markers[i].setMap(map);
				markers[i].position=0;
				}
		}

		function hideMarkers() {
 		 setMapOnAll(null);
		}
		function deleteMarkers() {
		hideMarkers();
		markers = [];
		}


	</script>
	<script async src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCBH-_Wnc-2JkqJ1xHKJD8ggIGlnBT1yMY&callback=initMap"></script>




@endsection
