@extends('layouts.app')

@section('contenido')

@if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
<section id="reservar" class="anfitrion justify-content-center align-items-center">
    <div class="container">
        <div class="row mt-5">
            <div class="col-sm-12 justify-content-center text-center">
                <h2 class="mb-1 mt-5">¡Te has registrado correctamente!</h2>
                <p>Puedes continuar navegando por el sitio y ver todo lo que YeAh! tiene para ofrecerte,
                    mientras verificamos tu cuenta, o puedes crear ya mismo tu primer experiencia.</p>
                <br>
                <a href="{{ route('home') }}" class="btn btn-secondary btn-lg">Finalizar registro</a>
                <br><br>
                <p>O...</p>
            </div>
        </div>
    </div>
    <div class="container">
		<form method="POST" action="{{ route('store-anfitriones-fisico.paso-2') }}" id="form_reg_2">
            @csrf
            <div class="row mt-5">
                <div class="col-sm-12 justify-content-center text-center">
                    <h2 class="mb-1 mt-5">Creá tu primer experiencia</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="col-md-6 offset-md-3 justify-content-center text-center">
                        <p class="bajada">Hola, estás a un paso de convertirte en anfitrión/a.</p>
                    </div>
                </div>
                <!--columna 1-->
                <div class="col-md-5 mt-2 text-center">
                    <!--FORMULARIO DATOS CREAR EXPERIENCIA-->
                    <h2 class="mb-1 mt-5">¿Qué título querés ponerle a tu experiencia?</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="text-left">
                        <div class="form-group">
                            <div class="form-group pb-2">
                                <input type="text" name="title" placeholder="Ingresá el titulo" class="form-control text-descripcion" required /><br />
                            </div>
                        </div>
                    </div>
                    <h2 class="mb-1 mt-5">Describí la experiencia</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <!--FORMULARIO DESCRIPCIÓN-->
                    <div class="text-left">
                        <div class="form-group pb-2">
                            <textarea style="height: 160px!important;resize: false" name="description" placeholder="Descipción de la experiencia" class="form-control renglones" required> </textarea><br />

                        </div>
                    </div>
                </div>

                <!--columna 2-->
                <div class="col-md-5 offset-md-1 text-center">
                    <h2 class="mb-1 mt-5">¿Qué incluye esta experiencia?</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <!--FORMULARIO DESCRIPCIÓN-->
                    <div class="text-left">
                        <input type="text" name="includes" placeholder="" class="form-control" required /><br />
                    </div>

                    <h2 class="mb-1 mt-5">Precio de la experiencia con IVA</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="text-left">
						<div class="input-group mb-3">
							<div class="input-group-prepend">
								<span class="input-group-text" style="background: transparent;border: 0;"><span class="icon-dollar form-control-feedback" aria-hidden="true"></span></span>
							</div>
                            <input type="number" name="price"  min="0" step=".01" placeholder="Ingresá el precio" class="form-control text-descripcion" required /><br />
						</div>
                    </div>

                    <h2 class="mb-1 mt-5">Ingresá un número telefónico para reservas</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="text-left">
						<div class="input-group mb-3">
							<div class="input-group-prepend">
								<span class="input-group-text" style="background: transparent;border: 0;"></span>
							</div>
                            <input type="tel" name="phone" value="{{$user->phone}}" placeholder="Ingresá el teléfono" class="form-control text-descripcion" required /><br />
						</div>
                    </div>
                </div>
            </div>
            <div class="row mb-5 mt-5 justify-content-sm-center">
                <div class="col-sm-4 text-center ">
                    <p><button type="submit" class="btn btn-secondary btn-lg btn-block">Siguiente</button></p>
                </div>
            </div>
		</form>
	</div>
</section>


@endsection
