@extends('layouts.app')

<style>
    #form_reg_0{
        display: none;
    }

    #form_reg_1{
        display: none;
    }
</style>

@section('contenido')
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    <section id="reservar" class="anfitrion justify-content-center align-items-center">
        <div class="container">
            <div class="row mt-5 ">
                <div class="col-sm-12 justify-content-center text-center">
                    <h2 class="mb-1 mt-5">Registro</h2>
                    <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                    <div class="col-md-6 offset-md-3 justify-content-center text-center">
                        <p class="bajada">Selecciona la opción que corresponda.</p>
                    </div>
                </div>
                <div class="col-md-3 text-center offset-md-3">
                    <div class="form-check">
                        <input class="form-check-input" onchange="mostrarFormulario()" type="radio" name="tipo_condicion" id="tipo_condicion_1" value="0">
                        <label class="form-check-label" for="tipo_condicion_1"> Física</label>
                    </div>
                </div>
                <div class="col-md-3 text-center">
                    <div class="form-check">
                        <input class="form-check-input" onchange="mostrarFormulario()" type="radio" name="tipo_condicion" id="tipo_condicion_2" value="1">
                        <label class="form-check-label"  for="tipo_condicion_2">Jurídica</label>
                    </div>
                </div>
            </div>


            <form method="POST" id="form_reg_0" action="{{ route('store-anfitriones-fisico.paso-1') }}" autocomplete="off">
                @csrf
                <div class="row mt-5 ">
                    <div class="col-sm-12 justify-content-center text-center">
                        <div class="col-md-6 offset-md-3 justify-content-center text-center">
                            <p class="bajada">Completa tus datos.</p>
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="nombre" id="nombre" aria-describedby="nombre" placeholder="Ingresá tu nombre" style="margin: 0 auto;" required>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="apellido" id="apellido" aria-describedby="apellido" placeholder="Ingresá tu apellido" style="margin: 0 auto;" required>
                        </div>
                    </div>
                    <div class="col-md-5  offset-md-1">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="address" id="address" aria-describedby="address" placeholder="Ingresá tu domicilio" style="margin: 0 auto;" required>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="fake_name" id="fake_name" aria-describedby="anf_reg_email" placeholder="Ingresá tu nombre de fantasía" style="margin: 0 auto;" required>
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="email" id="anf_reg_email" placeholder="Ingresá tu email" style="margin: 0 auto;" required>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="tel" class="form-control text-descripcion" name="celular" id="celular" aria-describedby="celular" placeholder="Ingresá tu celular" style="margin: 0 auto;" required>
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="number" class="form-control text-descripcion" name="cuit" id="cuit" aria-describedby="cuit" placeholder="Ingresá tu CUIT" style="margin: 0 auto;" required>
                        </div>
                    </div>

                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="password" class="form-control text-descripcion" name="password" id="anf_reg_pass" placeholder="Ingresá tu contraseña" style="margin: 0 auto;" required>
                            <small style="text-align:left;display: block;">La contraseña debe incluir una mayúscula y al menos un caracter alfanumérico.</small>
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="password" class="form-control text-descripcion" name="password2" id="password2" placeholder="Reingresá tu contraseña" style="margin: 0 auto;" autocomplete="off"  required>
                        </div>
                    </div>

                    <div class="col-md-5" style="display: none;">
                        <div class="form-group">
                            <select class="form-control" name="genero" id="sexo" style="margin: 0 auto;" required>
                                <option value=""  disabled>Género</option>
                                <option value="Otro">Otro</option>
                                <option value="Mujer">Femenino</option>
                                <option value="Hombre" selected>Masculino</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="date" class="form-control datepickerF hasDatepicker text-descripcion" name="fecha_nac" id="fecha_nac" placeholder="Fecha de nacimiento" style="margin: 0 auto;" autocomplete="off" required>
                            <small style="text-align:left;display: block;">Año de nacimiento</small>
                        </div>
                    </div>
                    <div class="col-md-5  offset-md-1">
                        <div class="form-group">
                            <select class="form-control mt-label" name="provincia" id="emp_provincia" style="margin: 0 auto;">
                                <option value="" disabled selected hidden>Provincia</option>
                                <option value="CABA">Ciudad Autónoma de Buenos Aires</option>
                                <option value="Buenos Aires">Buenos Aires</option>
                                <option value="Catamarca">Catamarca</option>
                                <option value="Chaco">Chaco</option>
                                <option value="Chubut">Chubut</option>
                                <option value="Córdoba">Córdoba</option>
                                <option value="Corrientes">Corrientes</option>
                                <option value="Entre Ríos">Entre Ríos</option>
                                <option value="Formosa">Formosa</option>
                                <option value="Jujuy">Jujuy</option>
                                <option value="La Pampa">La Pampa</option>
                                <option value="La Rioja">La Rioja</option>
                                <option value="Mendoza">Mendoza</option>
                                <option value="Misiones">Misiones</option>
                                <option value="Neuquén">Neuquén</option>
                                <option value="Río Negro">Río Negro</option>
                                <option value="Salta">Salta</option>
                                <option value="San Juan">San Juan</option>
                                <option value="San Luis">San Luis</option>
                                <option value="Santa Cruz">Santa Cruz</option>
                                <option value="Santa Fe">Santa Fe</option>
                                <option value="Santiago del Estero">Santiago del Estero</option>
                                <option value="Tierra del Fuego">Tierra del Fuego</option>
                                <option value="Tucuman">Tucuman</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="localidad" id="nombre" aria-describedby="nombre" placeholder="Ingresá tu localidad" style="margin: 0 auto;" required>
                        </div>
                    </div>
                </div>

                <div class="row mb-3 mt-5 justify-content-sm-center">
                    <div class="col-sm-4 text-center ">
                        <p class="bajada">Situación ante IVA:</p>
                        <div class="form-check">

                            <div class="text-left" style="display: flex;">
                                <p style="display: inline-block; margin-right: 10px;">Responsable inscripto</p>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="responsable_insc" id="yes" value="1">
                                    <label class="form-check-label" for="yes" style="margin-right: 12px;"> Si</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="responsable_insc" id="no" value="0" checked="checked">
                                    <label class="form-check-label" for="no"> No</label>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="row ocultomens">
                    <div class="col-md-4 offset-md-4">
                        <div class="alert alert-danger" id="msjregs"></div>
                    </div>
                </div>

                <div class="row justify-content-md-center">
                    <div class="col-md-5" style="text-align: center;">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" id="inlineCheckbox1" required>
                            <label class="form-check-label" for="inlineCheckbox1" style="font-size:14px;font-weight: 400; margin-bottom:0;">
                                He leído y acepto los <a href="{{ url('/terminos_y_condiciones') }}" target="_blank">Términos y Condiciones de uso</a></label>
                        </div>
                    </div>
                </div>

                <div class="row mb-5 mt-3 justify-content-sm-center">
                    <div class="col-sm-4 text-center ">
                        <p><button type="submit" class="btn btn-secondary btn-lg btn-block">Siguiente</button></p>
                    </div>
                </div>
            </form>

            <!-- registro persona juridica -->
            <form method="POST" id="form_reg_1" action="{{ route('registro-anfitriones-juridico.paso-2') }}" autocomplete="off">
                @csrf
                <div class="row mt-5 ">
                    <div class="col-sm-12 justify-content-center text-center">
                        <div class="col-md-6 offset-md-3 justify-content-center text-center">
                            <p class="bajada">Completa los datos de la empresa.</p>
                        </div>
                    </div>
                    <div class="col-md-5 ">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="emp_razon_social" id="emp_razon_social" aria-describedby="emp_razon_social" placeholder="Razón social" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="emp_cuit" id="emp_cuit" aria-describedby="emp_cuit" placeholder="CUIT" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5 ">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="fake_name" id="fake_name" aria-describedby="fake_name" placeholder="Ingresá tu nombre de fantasía" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="emp_telefono" id="emp_telefono" aria-describedby="emp_telefono" placeholder="Ingresá el teléfono de la empresa" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="emp_direccion" id="emp_direccion" aria-describedby="emp_direccion" placeholder="Ingresá la dirección de la empresa" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <select class="form-control mt-label" name="emp_provincia" id="emp_provincia" style="margin: 0 auto;">
                                <option value="X">Provincia</option>
                                <option value="0">Ciudad Autónoma de Buenos Aires</option>
                                <option value="1">Buenos Aires</option>
                                <option value="2">Catamarca</option>
                                <option value="3">Chaco</option>
                                <option value="4">Chubut</option>
                                <option value="5">Córdoba</option>
                                <option value="6">Corrientes</option>
                                <option value="7">Entre Ríos</option>
                                <option value="8">Formosa</option>
                                <option value="9">Jujuy</option>
                                <option value="10">La Pampa</option>
                                <option value="11">La Rioja</option>
                                <option value="12">Mendoza</option>
                                <option value="13">Misiones</option>
                                <option value="14">Neuquén</option>
                                <option value="15">Río Negro</option>
                                <option value="16">Salta</option>
                                <option value="17">San Juan</option>
                                <option value="18">San Luis</option>
                                <option value="19">Santa Cruz</option>
                                <option value="20">Santa Fe</option>
                                <option value="21">Santiago del Estero</option>
                                <option value="22">Tierra del Fuego</option>
                                <option value="23">Tucumán</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="emp_ciudad" id="emp_ciudad" aria-describedby="emp_ciudad" placeholder="Ciudad" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="nombre" id="nombre_emp" aria-describedby="nombre_emp" placeholder="Ingresá el nombre del responsable" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="apellido" id="apellido_emp" aria-describedby="apellido_emp" placeholder="Ingresá el apellido del responsable" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="search" class="form-control text-descripcion" name="celular" id="celular_e" aria-describedby="celular_e" placeholder="Ingresá el celular del responsable" style="margin: 0 auto;" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="text" class="form-control text-descripcion" name="anf_reg_email" id="anf_reg_email_e" aria-describedby="anf_reg_email_e" placeholder="Ingresá tu email" style="margin: 0 auto;">
                        </div>
                    </div>
                    <div class="col-md-5 offset-md-1">
                        <div class="form-group">
                            <input type="password" class="form-control text-descripcion" name="anf_reg_pass" id="anf_reg_pass_e" placeholder="Ingresá tu contraseña" style="margin: 0 auto;" autocomplete="new-password">
                            <small style="text-align:left;display: block;">La contraseña debe incluir una mayúscula y al menos un caracter alfanumérico.</small>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <input type="password" class="form-control text-descripcion" name="anf_reg_pass2" id="anf_reg_pass2_e" placeholder="Reingresá tu contraseña" style="margin: 0 auto;" autocomplete="off">
                        </div>
                    </div>
                </div>
                <input type="hidden" name="tipo_persona" value="1">

                <div class="row mb-3 mt-5 justify-content-sm-center">
                    <div class="col-sm-4 text-center ">
                        <p class="bajada">Situación ante IVA:</p>
                        <div class="form-check">

                            <div class="text-left" style="display: flex;">
                                <p style="display: inline-block; margin-right: 10px;">Responsable inscripto</p>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="reserva" id="yes" value="1">
                                    <label class="form-check-label" for="yes" style="margin-right: 12px;"> Si</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="reserva" id="no" value="0" checked="checked">
                                    <label class="form-check-label" for="no"> No</label>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="row justify-content-md-center">
                    <div class="col-md-5" style="text-align: center;">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox" id="aceptatyc" value="option1">
                            <label class="form-check-label" for="inlineCheckbox1" style="font-size:14px;font-weight: 400;margin-bottom:0;">He leído y acepto los <a href="#">Términos y Condiciones de uso</a></label>
                        </div>
                    </div>
                </div>

                <div class="row mb-5 mt-3 justify-content-sm-center">
                    <div class="col-sm-4 text-center ">
                        <p><button type="submit" class="btn btn-secondary btn-lg btn-block">Siguiente</button></p>
                    </div>
                </div>
            </form>
        </div>
    </section>

    <script>
        let form_reg_0 = document.getElementById('form_reg_0');
        let form_reg_1 = document.getElementById('form_reg_1');

        const fisica = document.getElementById('tipo_condicion_1');
        const juridica = document.getElementById('tipo_condicion_2');

        function mostrarFormulario()
        {
            if(fisica.checked)
            {
                form_reg_0.style.display = "block";
                form_reg_1.style.display = "none";
            }
            else
            {
                form_reg_0.style.display = "none";
                form_reg_1.style.display = "block";
            }
        }
    </script>

@endsection

