@extends('layouts.app')

@section('contenido')

<section class="ftco-section no-gutters mb-2" id="generica">
    <div class="container">
        @include('components.profile-header', ['user'=>$user])
    </div>
    <div class="container">
        <div class="row pb-2">
            <div class="col-sm-12 mb-5 text-center">
                <h3 class="mt-5">Redimir Código</h3>
                <hr/>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row pb-2">
            
            <div class="col-sm-12 mb-5 text-center">
                <p>Desde esta sección, puede ingresar un código que el cliente tenga para verificar si se trata de un cupón válido de Yeah!.
                En caso de ser correcto, podrá realizar la experiencia y envíar posteriormente la factura a Yeah!</p>
            </div>
        </div>
    </div>

    <div class="row pb-2">
        <div class="col-md-12 mb-5 ">
            <div class="container">
                <div class="row text-center justify-content-center align-items-center">
                    <div class="col-md-4">
                        <div class="bloqueRedimir">

                        </div>
                        @if($errors->any())
                        
                            <small style="color: red">{{$errors->first()}}</small>
                        @endif
                        <form action="{{ url('/redimir-codigo') }}" method="post">
                            @csrf
                            <div class="form-group mt-5">
                                <input type="text"
                                       class="form-control"
                                       name="code"
                                       aria-describedby="codigoRed"
                                       placeholder="Ingrese el Código"
                                       minlength="8"
                                       maxlength="12"
                                       required>
                            </div>
                            <div class="form-group mt-5">
                                <button class="btn btn-secondary btn-block" type="submit">Validar</button>
                            </div>

                        </form>

                        <div class="bloqueRedimirResultado"></div>
                    </div><!-- col-md-12 -->
                </div><!-- row -->
            </div><!-- container -->
        </div>
    </div>

</section>

@endsection
