@extends('layouts.app')

@section('contenido')

<!-- SECCIÓN Mis Compras -->
<section class="ftco-section no-gutters mb-2" id="generica">
    <div class="container">
        @include('components.profile-header', ['user'=>$user])
    </div>
    <div class="container">
        <div class="row pb-2">
            <div class="col-sm-12 mb-5 text-center">
                <h3 class="mt-5">Mis Reservas</h3>
                <hr/>
            </div>
        </div>
        <div class="row pb-2">
            <div class="col-md-12 mb-5 ">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">
                                    <a href="{{ route('bloquear-fecha',Auth::user()) }}" style="width: min-content;margin-bottom: 2%;" class="btn btn-secondary btn-block">Bloquear fecha</a>
                                    <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                        <thead class="thead-dark">
                                        <tr>
                                            <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                            <th class="encabezadoTabla">Experiencia</th>
                                            <th class="encabezadoTabla">Comprador nombre</th>
                                            <th class="encabezadoTabla">Comprador correo</th>
                                            <th class="encabezadoTabla">Fecha Reserva</th>
                                            <th class="encabezadoTabla">Estado Experiencia</th>
                                            <th class="encabezadoTabla">Estado Reserva</th>
                                            <th class="encabezadoTabla">Fecha de emision</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($reservas as $reserva)
                                                <tr>
                                                    @isset($reserva)
                                                    <td>
                                                        <img style="width: 100%" src="/storage/experiencias/{{$reserva->experiencia}}">
                                                    </td>
                                                    <td>{{ $reserva->experiencia->title }}</td>
                                                    <td>{{ $reserva->user->name }}</td>
                                                    <td>{{ $reserva->user->email }}</td>
                                                    <td>{{ $reserva->reserva }}</td>
                                                    <td>{{ $reserva->finalizada == 1 ? 'Realizada' : 'Sin realizar' }}</td>
                                                    <td>Correcta</td>
                                                    <td>{{ $reserva->created_at}}</td>
                                                    @endisset
                                                </tr>
                                            @endforeach
                                            {{-- {{ $experiencias->links() }} --}}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div>
        </div>
    </div><!-- container -->
</section>


@endsection
