@extends('layouts.app')

@section('contenido')

    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container">
            @include('components.profile-header', ['user'=>$user])
        </div>
        <div class="container">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Mis Experiencias</h3>
                    <hr/>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <a href="{{ url('/crear-experiencia') }}" class="btn btn-primary">Crear Experiencia</a>
                </div>
            </div>
        </div>
        @if($errors->any())
            <h4 id="message" style="text-align: center">{{$errors->first()}}</h4>
            <br>
        @endif
        <div class="row pb-2">
            <div class="col-md-12 mb-5 ">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">
                                    <table id="listado1" class="table table-hover" cellspacing="0" width="100%">
                                        <thead class="thead-dark">
                                        <tr>
                                            <th class="encabezadoTabla" style="width: 10%">Foto</th>
                                            <th class="encabezadoTabla">Experiencia</th>
                                            <th class="encabezadoTabla">Precio</th>
                                            <th class="encabezadoTabla">Ubicacion</th>
                                            <th class="encabezadoTabla">Ciudad</th>
                                            <th class="encabezadoTabla">Provincia</th>
                                            <th class="encabezadoTabla">Fecha de creacion</th>
                                            <th class="encabezadoTabla">Duracion</th>
                                            <th class="encabezadoTabla">Activa</th>
                                            <th class="encabezadoTabla">Editar Experiencia</th>
                                            <th class="encabezadoTabla">Editar Horarios</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($experiencias as $experiencia)
                                            <tr>
                                                <td><img style="width: 100%" src="/storage/experiencias/{{ $experiencia->picture }}"></td>
                                                <td>{{ $experiencia->title }}</td>
                                                <td>${{ $experiencia->price }}</td>
                                                <td>{{ $experiencia->location }}</td>
                                                <td>{{ $experiencia->city }}</td>
                                                <td>{{ $experiencia->province }}</td>
                                                <td>{{ $experiencia->created_at }}</td>
                                                <td>{{ $experiencia->hours }}</td>
                                                <td>{!! $experiencia->valid == 1 ? "<span style='font-weight: bold;'>Si</span>" : "<span style='font-weight: bold;'>No</span>" !!}</td>
                                                <td>
                                                    <a href="{{ url('/editar-experiencia/'.$experiencia->id) }}">
                                                        <i class="fas fa-pencil-alt"></i>
                                                    </a>
                                                </td>
                                                <td>
                                                    @if ($experiencia->reservation == "Con reserva")
                                                        <a href="{{ route('bloquear-horario',$experiencia) }}" style="line-height:0px;color: white" class="btn btn-primary">Asignar horario</a>
                                                    @else
                                                        <p>S/Reserva</p>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div>
        </div>
    </section>

    <script>
        $message = document.getElementById("message");
        if ($message != null) {
            setTimeout(function () {
                $message.remove();
            }, 4400);
        }
    </script>
@endsection
