@extends('layouts.app')
<head>
    <link type="text/css" rel="stylesheet" href="{{ asset('css/image-uploader.css') }}">
</head>
<style>
    #form-expe{
        display: inline;
        width: 100%;
    }
    #error_validacion{
        display: none;
        color: red;
    }
</style>
@section('contenido')

    <section class="ftco-section no-gutters mb-2" id="generica">
        <div class="container">
            @include('components.profile-header', ['user'=>$user])
        </div>
        <div class="container">
            <div class="row pb-2">
                <div class="col-sm-12 mb-5 text-center">
                    <h3 class="mt-5">Editar Experiencia | {{ $experiencia->title }}</h3>
                    <hr/>
                </div>
            </div>
        </div>

        <form class="container" id="contact-form"
              action="{{ url('/editar-experiencia-guardar') }}" method="post"
              enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <div class="row">
                    <div class="col">

                        <input type="hidden" style="display:none;" name="expe_id" class="form-control" placeholder="" value="{{ $experiencia->id }}" required />

                        <label for="nombre">Título</label>
                        <input type="text" name="title" id="title" class="form-control" placeholder="" value="{{ $experiencia->title }}" required />
                        <br>

                        <label for="description">Descripción</label>
                        <textarea name="description"
                                  rows="5"
                                  class="form-control"
                                  required>{{ $experiencia->description }}</textarea>
                        <br />

                        <label for="price">Precio</label>
                        <input type="number" name="price" min="0" step=".01" class="form-control" value="{{ $experiencia->price }}"
                               placeholder="Valor a facturar por la experiencia" required />
                        <br />

                        <label for="reservations_phone" class="mt-3">Teléfono de reservas</label>
                        <input type="text" name="reservations_phone" class="form-control" placeholder="Teléfono para reservas único para esta experiencia (opcional)"  />
                        <br />

                        <label for="hours">Duracion</label>
                        <input type="number" name="hours" class="form-control" value="{{ $experiencia->hours }}" placeholder="Duración en horas" required />
                        <br />

                        <label for="video">Video URL</label>
                        <input type="text" name="video" class="form-control" value="{{ $experiencia->video }}" placeholder="Dirección para compartir (opcional)" />
                        <br />

                        <label for="includes">Que incluye?</label>
                        <input type="text" name="includes" class="form-control" value="{{ $experiencia->includes }}" placeholder="Equipamiento, comida u otros..." />
                        <br />

                        <label for="extra_indications">Indicaciones extra</label>
                        <input type="text" name="extra_indications" class="form-control" value="{{ $experiencia->extra_indications }}" required />
                        <br />

                        <label for="what_bring">Que llevar?</label>
                        <input type="text" name="what_bring" class="form-control" value="{{ $experiencia->what_bring }}" placeholder="Ropa cómoda, equipo necesario, etc." required />
                        <br />

                        <h4>Categorias:</h4>
                        <div class="form-check text-left">
                            @foreach($categorias as $categoria)
                                <input type="checkbox" name="categorias[]" value="{{$categoria->id}}" />
                                <label for="categoria_{{$categoria->id}}" class="label-check">{{$categoria->title}}</label> <br>
                            @endforeach
                        </div>
                        <br>

                        <label for="picture">Foto principal</label>
                        <input name="picture" type="file" class="form-control" id="picture" placeholder="" required />
                        <br><br>
                        <div id="error_validacion">
                            Los campos marcados con * son requeridos.
                        </div>

                        <h4 class="mb-1 mt-5">Fotos de tu experiencia</h4>
                        <p></p><div class="zigzag pb-2 f-none"></div><p></p>
                        <p class="bajada mb-1 mt-5 text-left">Fotos extra</p>
                        <div>
                            <div class="input-images-2" style="padding-top: .5rem;"></div>
                        </div>

                    </div>
                    <div class="col">
                        <label for="city">Ciudad</label>
                        <input type="text" name="city" value="{{ $experiencia->city }}" class="form-control" required />
                        <br />

                        <label for="province">Provincia</label>
                        <input type="text" name="province" value="{{ $experiencia->province }}" placeholder="Provincia de la experiencia" class="form-control" required />
                        <br />

                        <label for="place_id">Lugar</label>
                        <select name="place_id" class="form-control" required>
                            <option value="" selected disabled>Seleccione el lugar</option>
                            @foreach($places as $place)
                                <option value="{{ $place->id }}">{{ $place->name }}</option>
                            @endforeach
                        </select>
                        <br>

                        <label for="more_about">Mas sobre la experiencia</label>
                        <input type="text" name="more_about" value="{{ $experiencia->more_about }}" class="form-control" required />
                        <br />

                        <label for="location">Ubicacion</label>
                        <input type="text" name="location" class="form-control" value="{{ $experiencia->location }}" placeholder="Ubicación aproximada del lugar" required />
                        <br />

                        <label for="coordenates">Coordenadas (x,y)</label>
                        <input type="text" name="coordenates" value="{{ $experiencia->coordenates }}" placeholder="Ej: 0.0000; 0.0000" class="form-control" required />
                        <br />

                        <label for="extra_indications">Indicaciones Extra</label>
                        <input type="text" name="extra_indications" value="{{ $experiencia->extra_indications }}" placeholder="Ej: En la tercer salida de la ruta 40..." class="form-control" required />
                        <br />

                        <label for="extra_indications">Teléfono de reservas</label>
                        <input type="text" name="reservations_phone" value="{{ $experiencia->reservations_phone }}" placeholder="Teléfono para reservas unicamente" class="form-control" required />
                        <br />

                        <p>Idiomas:</p>
                        <input type="checkbox" name="español" value="español" /> <label for="languajes" class="label-check">Español</label>
                        <input type="checkbox" name="ingles" value="ingles" /> <label for="languajes" class="label-check">Inlges</label>
                        <input type="checkbox" name="italiano" value="italiano" /> <label for="languajes" class="label-check">Italiano</label>
                        <input type="checkbox" name="portugues" value="portugues" /> <label for="languajes" class="label-check">Portugues</label>
                        <input type="checkbox" name="frances" value="frances" /> <label for="languajes" class="label-check">Frances</label>
                        <input type="checkbox" name="aleman" value="aleman" /> <label for="languajes" class="label-check">Aleman</label>
                        <br /><br /><br />

                        <label for="must_learn_languaje">El turista debe conocer el idioma/s</label>
                        <select name="must_learn_languaje" class="form-control">
                            <option value="1">Si</option>
                            <option value="0">No</option>
                        </select>
                        <br>

                        <label for="require_validation_user">Requiere que el usuario este validado</label>
                        <select name="require_validation_user" class="form-control">
                            <option value="1">Si</option>
                            <option value="0">No</option>
                        </select>
                        <br>

                        <label for="reservation">Requiere Reserva</label>
                        <select name="reservation" class="form-control">
                            <option value="1">Si</option>
                            <option value="0">No</option>
                        </select>
                        <br>

                    </div>
                </div>
                <br><br>
                <div class="row pb-2">
                    <div class="col-sm-12 mb-5 text-center">
                        <button type="submit" class="btn btn-primary" style="color: white; font-weight: bold">Actualizar</button>
                    </div>
                </div>
            </div>
        </form>

    </section>

    @php
    $count=count($experiencia->images->where('is_principal',false));
    $varJS = array();
    foreach ($experiencia->images->where('is_principal',false) as $image) {
        array_push($varJS,"/storage/experiencias/".$image->url_image."");

    }
@endphp

    <script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
    <script type="text/javascript" src="{{ asset('js/image-uploader.js') }}"></script>

    <script>

let count={!! json_encode($count) !!};
    var preloaded = [];
    var values = {!! json_encode($varJS) !!}
    if(values != []){
        for(var i = 0; i < count; i++){
        preloaded.push({id: i, src: values[i]});
        }
    }


        $('.input-images-2').imageUploader({
            label: 'Arrastra o hace click para cargar imagenes',
            imagesInputName: 'preloaded_images',
            maxSize:4 * 1024 * 1024,
            preloadedInputName:'preloaded_images',
            preloaded:preloaded,
        });


    </script>
@endsection
