@extends('layouts.app')

@section('contenido')

<!-- SECCIÓN Mis Compras -->
<section class="ftco-section no-gutters mb-2" id="generica">
    <div class="container">
        @include('components.profile-header', ['user'=>$user])
    </div>
    <div class="container">
        <div class="row pb-2">
            <div class="col-sm-12 mb-5 text-center">
                <h3 class="mt-5">Asignar un horario para <strong style="color: black;background: rgb(255, 193, 7);">{{ $experiencia->title }}</strong> </h3>
                <hr/>
            </div>
        </div>
        <div class="row pb-2">
            <div class="col-md-12 mb-5 ">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <p style="text-align: center">Asignar un horario permitira que la gente solo pueda reservar tu experiencia dentro de los horarios que definas!</p>
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">
                                    @if(!$horarios_bloqueados)
                                    <form action="{{ route('bloquear-horario-post',$experiencia) }}"  method="POST" id="formcontacto">
                                        @csrf
                                        <br><br>
                                        <input type="checkbox" value="0" name="dias_laborales[]" /> <label for="dias" class="label-check">Lunes</label>
                                        <input type="checkbox" value="1" name="dias_laborales[]" /> <label for="dias" class="label-check">Martes</label>
                                        <input type="checkbox" value="2" name="dias_laborales[]" /> <label for="dias" class="label-check">Miercoles</label>
                                        <input type="checkbox" value="3" name="dias_laborales[]" /> <label for="dias" class="label-check">Jueves</label>
                                        <input type="checkbox" value="4" name="dias_laborales[]" /> <label for="dias" class="label-check">Viernes</label>
                                        <input type="checkbox" value="5" name="dias_laborales[]" /> <label for="dias" class="label-check">Sabado</label>
                                        <input type="checkbox" value="5" name="dias_laborales[]" /> <label for="dias" class="label-check">Domingo</label>
                                        <br><br>

                                        <br>
                                        <label for="cantidad_de_reservas">Limite de personas por dia que tendra la experiencia</label>
                                            <select style="width: 100%;height: 3rem;margin-bottom: 5%;" name="cantidad_de_reservas">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <option value="{{ $i }}">{{ $i }}</option>
                                                @endfor
                                            </select>
                                        <br>
                                        <label for="hora_inicio">Horario de inicio de reservas para la experiencia</label>
                                        <select style="width: 100%;height: 3rem;margin-bottom: 5%;" name="hora_inicio">
                                            @for ($i = 0; $i <= 24; $i++)
                                                <option value="{{ $i }}:00:00">{{ $i }}:00 @if ($i >12) Pm @else Am @endif</option>
                                            @endfor
                                        </select>
                                        <label for="hora_fin">Horario de finalizacion de reservas para la Experiencia</label>
                                        <select style="width: 100%;height: 3rem;margin-bottom: 5%;" name="hora_fin">
                                            @for ($i = 0; $i <= 24; $i++)
                                                <option value="{{ $i }}:00:00">{{ $i }}:00 @if ($i >12)Pm @else Am @endif</option>
                                            @endfor
                                        </select>

                                        <button type="submit" class="btn-form" id="btnEnviarcotnacto">Asignar</button>
                                    </form>
                                    @else
                                        <form action="{{ route('bloquear-horario-post',$experiencia) }}"  method="POST" id="formcontacto">
                                            @csrf
                                            <br><br>
                                            <input type="checkbox" value="1" name="dias_laborales[]" @foreach (explode(" ", str_replace('-', ' ', $horarios_bloqueados->dias_laborales)) as $dia)@if ($dia ==1)checked @endif @endforeach /> <label for="dias" class="label-check">Lunes</label>
                                            <input type="checkbox" value="2" name="dias_laborales[]"  @foreach (explode(" ", str_replace('-', ' ', $horarios_bloqueados->dias_laborales)) as $dia)@if ($dia ==2)checked @endif @endforeach /> <label for="dias" class="label-check">Martes</label>
                                            <input type="checkbox" value="3" name="dias_laborales[]"  @foreach (explode(" ", str_replace('-', ' ', $horarios_bloqueados->dias_laborales)) as $dia)@if ($dia ==3)checked @endif @endforeach /> <label for="dias" class="label-check">Miercoles</label>
                                            <input type="checkbox" value="4" name="dias_laborales[]"  @foreach (explode(" ", str_replace('-', ' ', $horarios_bloqueados->dias_laborales)) as $dia)@if ($dia ==4)checked @endif @endforeach /> <label for="dias" class="label-check">Jueves</label>
                                            <input type="checkbox" value="5" name="dias_laborales[]"  @foreach (explode(" ", str_replace('-', ' ', $horarios_bloqueados->dias_laborales)) as $dia)@if ($dia ==5)checked @endif @endforeach /> <label for="dias" class="label-check">Viernes</label>
                                            <input type="checkbox" value="6" name="dias_laborales[]"  @foreach (explode(" ", str_replace('-', ' ', $horarios_bloqueados->dias_laborales)) as $dia)@if ($dia ==6)checked @endif @endforeach /> <label for="dias" class="label-check">Sabado</label>
                                            <input type="checkbox" value="0" name="dias_laborales[]"  @foreach (explode(" ", str_replace('-', ' ', $horarios_bloqueados->dias_laborales)) as $dia)@if ($dia ==0)checked @endif @endforeach /> <label for="dias" class="label-check">Domingo</label>
                                            <br><br>
                                            <label for="cantidad_de_reservas">Limite de personas por dia que tendra la experiencia</label>
                                            <select style="width: 100%;height: 3rem;margin-bottom: 5%;" name="cantidad_de_reservas">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <option value="{{ $i }}">{{ $i }}</option>
                                                @endfor
                                            </select>
                                            <br>
                                            <label for="hora_inicio">Horario de inicio de reservas para la experiencia</label>
                                            <select style="width: 100%;height: 3rem;margin-bottom: 5%;" name="hora_inicio">
                                                @for ($i = 0; $i <= 24; $i++)
                                                    <option @if($i.":00:00" == $horarios_bloqueados->hora_desde) selected @endif value="{{ $i }}:00:00">{{ $i }}:00 @if ($i >12) Pm @else Am @endif</option>
                                                @endfor
                                            </select>
                                            <label for="hora_fin">Horario de finalizacion de reservas para la Experiencia</label>
                                            <select style="width: 100%;height: 3rem;margin-bottom: 5%;" name="hora_fin">
                                                @for ($i = 0; $i <= 24; $i++)
                                                    <option @if($i.":00:00" == $horarios_bloqueados->hora_hasta) selected @endif value="{{ $i }}:00:00">{{ $i }}:00 @if ($i >12)Pm @else Am @endif</option>
                                                @endfor
                                            </select>
                                            <button type="submit" class="btn-form" id="btnEnviarcotnacto">Asignar</button>
                                        </form>
                                    @endif
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                    <div class="row">
                        <h3 class="mt-5">Bloquear dias:</h3>
                    </div>
                    <p>Bloquear fechas en las cuales no desee obtener reservas.</p>
                    <br>
                    <a href="{{ route('bloquear-fecha',Auth::user()) }}" style="width: min-content;margin-bottom: 2%;" class="btn btn-secondary btn-block">Bloquear fecha</a>
                </div><!-- container -->
            </div>
        </div>
    </div><!-- container -->
</section>
@endsection
