@extends('layouts.app')

@section('contenido')

<!-- SECCIÓN Mis Compras -->
<section class="ftco-section no-gutters mb-2" id="generica">
    <div class="container">
        @include('components.profile-header', ['user'=>$user])
    </div>
    <div class="container">
        <div class="row pb-2">
            <div class="col-sm-12 mb-2 text-center">
                <h3 class="mt-5">Bloquear Fecha</h3>
                <hr/>
            </div>
        </div>
        <div class="col-sm-12 mb-5 text-center">
            <p>Desde esta sección puede bloquear fechas. Si tiene días con demasiadas reservas, puede bloquear un día para no recibir
            reservas en todo ese día.</p>
        </div>
    </div>
        <div class="row pb-2 justify-content-center">
            <div class="col-md-6 mb-5">
                <div class="container-fluid">
                    <div class="row align-items-left">
                        <div class="col-md-12">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="misExperiencias" role="tabpanel" aria-labelledby="misExperiencias-tab">
                                    <form action="{{ route('bloquear-fecha-post') }}" method="POST" id="formcontacto">
                                        @csrf
                                            <label for="Selecciona la experiencia que queres bloquear"></label>
                                            <select style="width: 100%;height: 3rem;margin-bottom: 5%;" name="experiencia_id" id="experiencia">
                                                @foreach ($experiencias as $experiencia)
                                                    <option value="{{ $experiencia->id }}">{{ $experiencia->title }}</option>
                                                @endforeach
                                            </select>
                                        <input type="date" name="fecha_a_bloquear" id="fecha_a_bloquear" class="form-input full-width">

                                        <button type="submit" class="btn-form" id="btnEnviarcotnacto">Bloquear</button>
                                    </form>
                                </div>
                            </div>
                        </div><!-- col-md-12 -->
                    </div><!-- row -->
                </div><!-- container -->
            </div>
        </div>
    </div><!-- container -->
</section>

<script>
var today = new Date();
var dd = today.getDate();
var mm = today.getMonth()+1;
var yyyy = today.getFullYear();
if(dd<10){
  dd='0'+dd
}
if(mm<10){
  mm='0'+mm
}

today = yyyy+'-'+mm+'-'+dd;
document.getElementById("fecha_a_bloquear").setAttribute("min", today);
</script>

@endsection
