@extends('admin.layout.admin')
<style>
    .hidden{
        display: none;
    }
    .info-message{
    visibility: hidden;
    color: #4B49AC;
    z-index: 200;
    position: absolute;
    top: 1rem;
    background-color: #b6b5ee;
    left: 16rem;
    font-size: 1.1rem;
    padding: 10px;
    border-bottom-left-radius: 2rem;
    border-bottom-right-radius: 1rem;
    border-top-right-radius: 1rem;
    }
    .info:hover>.info-message{
        visibility: visible;
    }

</style>
@section('contenido')
<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">Experiencias realizadas</h3>
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="table_data" class="display expandable-table" style="width:100%">
                                    <thead>
                                    <tr>
                                        <th style="cursor: pointer; min-width: 115px" >Fecha de alta<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th class="info" style="cursor: pointer;z-index: 1; min-width: 115px;color:#4B49AC;background-color: #ffffff;" >Numero de venta<i class="ml-4 fas fa-caret-down"></i>
                                            <span class="info-message">Podes consultar todas venta en la seccion "ventas totales" </span>
                                        </th>
                                        <th style="cursor: pointer" >Quien compra<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Quien compra (email)<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Experiencia<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Anfitrion<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Precio (Experiencia)<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th>Estado</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse ($ventas as $venta)
                                        <tr>
                                            <td>
                                                <p>{{$venta->created_at->format('d-m-Y')}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->id}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->user->name}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->user->email}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->experiencia->title}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->experiencia->user->name}}</p>
                                            </td>
                                            <td>
                                                <p>$ {{$venta->amount}}.00</p>
                                            </td>
                                            </td>
                                            <td>
                                                <p>{{$venta->approved == 1 ? "Pago aprobado" : "Pendiente"}}</p>
                                            </td>
                                            <td>
                                                @if($venta->codigoCanjeable)
                                                    <p> {{$venta->codigoCanjeable->used == 1 ? "Utilizado" : "Pendiente de uso" }}</p>
                                                @else
                                                    -
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <td >No hay registros para mostrar</td>
                                    @endforelse
                                    </tbody>
                                </table>
                                <div class="d-flex justify-content-center" style="padding-bottom: 10px;">
                                    {{ $ventas->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
