@extends('admin.layout.admin')
<style>
    .hidden{
        display: none;
    }
</style>
@section('contenido')
<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">Ventas {{ $tipo }}</h3>
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="table_data" class="display expandable-table" style="width:100%">
                                    <thead>
                                    <tr>
                                        <th style="cursor: pointer; min-width: 115px" >Fecha de Carga<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Codigo<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Quien canjea<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Quien canjea (email)<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Experiencia<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Anfitrion<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th style="cursor: pointer" >Precio (Experiencia)<i class="ml-4 fas fa-caret-down"></i></th>
                                        <th>Estado</th>
                                        <th>Borrar</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse ($ventas as $venta)
                                        <tr>
                                            <td>
                                                <p>{{$venta->created_at->format('d-m-Y')}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->codigoCanjeable->code}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->user->name}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->user->email}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->experiencia->title}}</p>
                                            </td>
                                            <td>
                                                <p>{{$venta->experiencia->user->name}}</p>
                                            </td>
                                            <td>
                                                <p>$ {{$venta->amount}}.00</p>
                                            </td>
                                            </td>
                                            <td>
                                                <p>{{$venta->codigoCanjeable->used == 1 ? "Utilizada" : "Pendiente de uso"}}</p>
                                            </td>
                                            <td>
                                                <div style="justify-content: space-around" class="row">
                                                    <form action="{{ route('venta.delete',$venta) }}" method="POST">
                                                        @csrf
                                                        <button style="border: none;background-color: transparent"><i style="color: gray" class="fa fa-trash"></i></button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <td >No hay registros para mostrar</td>
                                    @endforelse
                                    </tbody>
                                </table>
                                <div class="d-flex justify-content-center" style="padding-bottom: 10px;">
                                    {{ $ventas->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
