@extends('admin.layout.admin')
<style>
    .label-check{
        margin-right: 15px;
    }
</style>
@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title">Editar Anfitrion</h3>
                        <div class="row">
                            <div class="col-12 form-group">
                                @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                                @endif
                                <form action="{{ url('/usuarios/editar/save') }}" method="post" enctype="multipart/form-data">
                                    @method('PUT')
                                    @csrf

                                    <input value="{{ $user->id }}" type="hidden" name="user_id" class="form-control" style="display: none;" required /><br />

                                    <label for="name">Nombre</label>
                                    <input value="{{ $user->name }}" type="text" name="name" placeholder="Nombre del anfitrion" class="form-control"  required /><br />

                                    <label for="email">Email</label>
                                    <input value="{{ $user->email }}" type="email" name="email" placeholder="Email del anfitrion" class="form-control" required /><br />

                                    <label for="gender">Genero</label>
                                    <select name="gender" id="" class="form-control">
                                        <option {{ $user->gender == 'Hombre' ? 'selected' : '' }} value="Hombre">Hombre</option>
                                        <option {{ $user->gender == 'Mujer' ? 'selected' : '' }} value="Mujer">Mujer</option>
                                    </select><br />

                                    <label for="city">Ciudad</label>
                                    <input value="{{ $user->city }}" type="text" name="city" placeholder="Ciudad del anfitrion" class="form-control" required /><br />

                                    <label for="phone">Telefono</label>
                                    <input value="{{ $user->phone }}" type="tel" name="phone" placeholder="Telefono para comunicacion" class="form-control" required /><br />

                                    <label for="province">Provincia</label>
                                    <input value="{{ $user->province }}" type="text" name="province" placeholder="Provincia en la que se encuentra" class="form-control" required /><br />

                                    <label for="country">Pais</label>
                                    <input value="{{ $user->country }}" type="text" name="country" placeholder="Pais de residencia" class="form-control" required /><br />

                                    <button type="submit" class="btn btn-success">Actualizar</button>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
