@extends('admin.layout.admin')

<style>
    .hidden{
        display: none;
    }
    .custom-form-control
    {
        border: none;
        border-bottom: 1px solid #bdbdbd;
        padding: 5px;
        min-width: 350px;
    }
</style>
@section('contenido')
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">Anfitriones</h3>
                    <h4 class="card-title">Buscar por nombre de fantasia/nombre real</h4>
                    <div class="row">
                        <div class="col-6">
                            <form method="post" action="{{ url('/search-anfitriones') }}">
                                @csrf
                                <input type="text" name="searched" class="custom-form-control" placeholder="Ingrese nombre real o de fantasia" required />
                                <button type="submit" class="btn btn-sm btn-success"><i class="icon-search"></i></button>
                            </form>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                  @include('admin.components.tablas/anfitriones-busqueda')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


 <!-- Modal Anfitrion Validado-->
 <div class="modal fade" data-dismiss="modal" id="validateUser" tabindex="-1" role="dialog" aria-labelledby="validateUser"
      aria-hidden="false" style="position: fixed; top: 0; height: 85%; padding-top: 0;">
<div class="modal-dialog amarillo" role="document">
    <div style="margin-right: 0px;margin-left: 0px;background-color: #4B49AC;border-right-width: 0px;border-left-width: 0px;width: 100%;" class="modal-content">
        <div class="modal-header">
            <h2 style="color: white" class="text-center">Confirmar</h2>
            <button type="button" id="close" class="close" data-dismiss="modal" aria-label="Close">
                <img src="{{ asset('svgs/close.png') }}" class="img-fluid">
            </button>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-md-12 ftco-animate text-center mb-2">
                    <h2 style="color: white" class="text-center">Validaras el anfitrion <br> continuar?</h2>
                    <div class="zigzag-blanco f-none"></div>
                </div>
                <div class="col-md-12 ftco-animate mt-5 mb-5">
                    <div style="border-radius: 25px" class="blog-entry">
                        <form style="width: 100%;" action="{{ route('admin.user.validate') }}" method="POST">
                                @csrf
                                <input type="hidden" name="user_id" id="validate_user_id">
                                <input type="hidden" name="anfitrion" value="2">
                                <button style="background-color: white;
                                color: #4B49AC;
                                font-size: larger;
                                font-weight: 900;" class="btn btn-secondary btn-md btn-block">Validar</button>
                        </form>
                    </div>
                </div>
            </div><!-- row -->
        </div>
    </div>
</div>
</div>

<script>

const modalValidateUser = document.getElementById("validateUser");
const closeButton = document.getElementById("close");

closeButton.addEventListener('click', function (){
      $('#validateUser').modal('hide');
});


$("button[id*='button_validate_']").click(function(e){
    let user_validate = document.getElementById("user_validate_"+this.id.replace('button_validate_',''));
    let validate_user_id = document.getElementById("validate_user_id");
    validate_user_id.value=user_validate.value
    $('#validateUser').modal();
});

</script>
@endsection

