@extends('admin.layout.admin')

<head>
    <link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link type="text/css" rel="stylesheet" href="{{ asset('css/image-uploader.css') }}">
</head>
@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title">Crear nuevo lugar</h3>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 form-group">
                                <form action="{{ url('/nuevo-lugar') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <label for="">Nombre del lugar:</label>
                                    <input type="text" name="name" class="form-control" placeholder="Elija el nombre" required />
                                    <br>

                                    <br>
                                    <label style="background-color: yellow">Imagen:</label>
                                    <div>
                                        <div class="imagenLugar" style="padding-top: .5rem;"></div>
                                    </div>
                                    <br>


                                    <label for="status">Elija el estado del lugar en el sitio:</label>
                                    <select name="status"  class="form-control" required>
                                        <option value="" disabled selected>Elija el estado</option>
                                        <option value="1">Activo</option>
                                        <option value="2">Pendiente</option>
                                    </select>
                                    <br>
                                    <br>

                                    <button type="submit" class="btn btn-success">Crear Lugar</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

<script type="text/javascript" src="{{ asset('js/image-uploader.js') }}"></script>

<script>
        
$('.imagenLugar').imageUploader({
    label: 'Arrastra o hace click para cargar la imagen del lugar',
    imagesInputName: 'image',
    maxFiles:1,
});
</script>


@endsection

