@extends('admin.layout.admin')

@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title">Crear centro Pick-Up</h3>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-9 col-lg-9 col-xl-9 form-group">
                                <form action="{{ url('/nuevo-lugar') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <label for="">Experiencia:</label>
                                    <select class="form-control" name="experiencia_id">
                                        @foreach ($experiencias as $experiencia)
                                            <option value="{{ $experiencia->id }}">{{ $experiencia->title }}</option>
                                        @endforeach
                                    </select>
                                    <br>

                                    <br>
                                    <label>Destinatario:</label>
                                        <select class="form-control" name="user_id">
                                            @foreach ($users as $user)
                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    <br>

                                    <br>
                                    <label for="status">Comprador:</label>
                                    <select class="form-control" name="buyer_id">
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                    <br>
                                    <br>
                                    
                                    <button type="submit" class="btn btn-success">Crear centro pick-up</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


