@extends('admin.layout.admin')
<head>
    <link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link type="text/css" rel="stylesheet" href="{{ asset('css/image-uploader.css') }}">
</head>
<style>
    .label-check{
        margin-right: 15px;
    }
</style>
@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title">Editar Experiencia</h3>
                        <div class="row">
                            <div class="col-12 form-group">
                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <form action="{{ route('experiencias.update',$experiencia) }}" method="POST" enctype="multipart/form-data">
                                    @method("PUT")
                                    @csrf
                                    <label for="title">Título</label>
                                    <input type="text" name="title" placeholder="Título de la experiencia" value="{{ $experiencia->title }}" class="form-control" required /><br />

                                    <label for="title">Título en ingles</label>
                                    <input type="text" name="title_en" placeholder="Título de la experiencia ingles" value="{{ $experiencia->title_en ?? ''}}" class="form-control" /><br />

                                    <label for="description">Descripción</label>
                                    <textarea name="description" id="description" placeholder="Descipción de la experiencia" rows="10" cols="50" class="form-control">{{ $experiencia->description }}</textarea><br/>

                                    <label for="description">Descripción en ingles</label>
                                    <textarea name="description_en" id="description_en" placeholder="Descipción de la experiencia ingles" rows="10" cols="50" class="form-control">{{$experiencia->description_en ?? ''  }}</textarea><br/>

                                    <label for="price">Precio</label>
                                    <input type="number" name="price" step=".01" placeholder="Precio de la experiencia" class="form-control" required value="{{ $experiencia->price }}" /><br />

                                    <label for="final_price">Precio Final</label>
                                    <input type="number" name="final_price" step=".01" placeholder="Precio final de la experiencia" class="form-control" required value="{{ $experiencia->final_price }}" /><br />

                                    <label for="final_price">IVA Seleccionado</label>
                                    <p>Iva seleccionado:
                                        @if($experiencia->iva_selector == 2)
                                            <strong>Si (21%)</strong>
                                        @elseif($experiencia->iva_selector == 1)
                                            <strong>Si (10.5%)</strong>
                                        @else
                                            <strong>No</strong>
                                        @endif
                                    </p>

                                    <label for="place">Ubicación</label>
                                    <input type="text" name="place" placeholder="Ubicación de la experiencia" class="form-control" required  value="{{ $experiencia->place }}"/><br />

                                    <label for="city">Ciudad</label>
                                    <input type="text" name="city" placeholder="Ciudad de la experiencia" class="form-control" required value="{{ $experiencia->city }}" /><br />

                                    <label for="province">Provincia</label>
                                    <input type="text" name="province" placeholder="Provincia de la experiencia" class="form-control" required value="{{ $experiencia->province }}"/><br />

                                    <label for="coordenates">Coordenadas</label>
                                    <input type="text" name="coordenates" placeholder="Coordenadas de la experiencia (xxxx,yyyy)" class="form-control" required value="{{ $experiencia->coordenates }}"/><br />

                                    <label for="main_page">Destacada</label>
                                    <select name="main_page" id="" class="form-control">
                                        <option {{ ( $experiencia->main_page == 0) ? 'selected' : '' }} value="0">No</option>
                                        <option {{ ( $experiencia->main_page == 1) ? 'selected' : '' }} value="1">Si</option>
                                    </select><br />

                                    <label for="hours">Horas</label>
                                    <input type="text" name="hours"  placeholder="Horas de duración" class="form-control" required value="{{ $experiencia->hours }}" /><br />

                                    <label for="includes">Incluye</label>
                                    <input type="text" name="includes" placeholder="Que incluye la experiencia" class="form-control" required value="{{ $experiencia->includes }}"/><br />
                                    <p>Idiomas:</p>
                                    <input {{ $experiencia->languajes == ' Español ' ? ' checked' : '' }} type="checkbox" name="español" value="español" /> <label for="languajes" class="label-check">Español</label>
                                    <input {{ $experiencia->languajes == ' Ingles ' ? ' checked' : '' }} type="checkbox" name="ingles" value="ingles" /> <label for="languajes" class="label-check">Ingles</label>
                                    <input {{ $experiencia->languajes == ' Italiano ' ? ' checked' : '' }} type="checkbox" name="italiano" value="italiano" /> <label for="languajes" class="label-check">Italiano</label>
                                    <input {{ $experiencia->languajes == ' Portugues ' ? ' checked' : '' }}  type="checkbox" name="portugues" value="portugues" /> <label for="languajes" class="label-check">Portugues</label>
                                    <input {{ $experiencia->languajes == ' Frances ' ? ' checked' : '' }} type="checkbox" name="frances" value="frances" /> <label for="languajes" class="label-check">Frances</label>
                                    <input {{ $experiencia->languajes == ' Aleman ' ? ' checked' : '' }} type="checkbox" name="aleman" value="aleman" /> <label for="languajes" class="label-check">Aleman</label>
                                    <br />

                                    <label for="must_learn_languaje">Turista: Necesita habla el idioma?</label>
                                    <select name="must_learn_languaje" class="form-control">
                                        <option {{ ( $experiencia->must_learn_languaje == 0) ? 'selected' : '' }} value="0">No</option>
                                        <option {{ ( $experiencia->must_learn_languaje == 1) ? 'selected' : '' }} value="1">Si</option>
                                    </select><br />

                                    <label for="what_bring">¿Qué llevar?</label>
                                    <input type="text" name="what_bring" placeholder="Que se debe llevar a la experiencia" class="form-control" required value="{{ $experiencia->what_bring }}" /><br />

                                    <label for="valid">Válida/Activa:</label>
                                    <select name="valid" class="form-control">
                                        <option value="1">Si</option>
                                        <option value="0">No</option>
                                    </select><br />

                                    <label for="extra_indications">Indicaciones extra</label>
                                    <input type="text" name="extra_indications" placeholder="Por ej: A una cuadra de la ruta..." class="form-control" required value="{{ $experiencia->extra_indications }}" /><br />

                                    <label for="reservations_phone">Teléfono (Reservas solamente)</label>
                                    <input type="text" name="reservations_phone" placeholder="Teléfono solo para reservas" class="form-control" value="{{ $experiencia->reservations_phone }}" required /><br />

                                    <label for="more_about">Más datos sobre la Experiencia</label>
                                    <textarea name="more_about" rows="10" cols="50" class="form-control" placeholder="Por ej: servimos postres variados...">{{ $experiencia->more_about }}</textarea><br/>

                                    <label for="place_id">Lugar:</label>
                                    <select name="place_id" class="form-control">
                                        <option value="0">Otro</option>
                                        @foreach($lugares as $lugar)
                                            <option value="{{ $lugar->id }}" {{ ( $experiencia->place_id == $lugar->id) ? 'selected' : '' }}>{{ $lugar->name }}</option>
                                        @endforeach
                                    </select><br />

                                    <label for="user_id">Anfitrion:</label>
                                    <select name="user_id" class="form-control">
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}" {{ ( $experiencia->user->name == $user->name) ? 'selected' : '' }}>{{ $user->user_details->fake_name }}</option>
                                        @endforeach
                                    </select><br />
                                    <label for="category">Categoria:</label>
                                        @foreach($categorias as $categoria)
                                            <input type="checkbox" name="categorias[]" {{ $experiencia->categories->first()->id == $categoria->id ? ' checked' : '' }} value="{{$categoria->id}}" /> <label for="categoria_{{$categoria->id}}" class="label-check">{{$categoria->title}}</label>
                                        @endforeach
                                    <br/>

                                    <label style="background-color: yellow">Imagen principal</label>
                                        <div>
                                            <div class="main_image" style="padding-top: .5rem;"></div>
                                        </div>
                                    <br>

                                    <label for="picture">Imagenes extra</label>
                                        <div>
                                            <div class="extra_images" style="padding-top: .5rem;"></div>
                                        </div>
                                    <br>

                                    <label for="reservation">¿Utiliza el panel de reservas Yeah?</label>
                                    <select name="reservation" class="form-control">
                                        <option {{ ( $experiencia->reservation == 0) ? 'selected' : '' }} value="0">No</option>
                                        <option {{ ( $experiencia->reservation == 1) ? 'selected' : '' }} value="1">Si</option>
                                    </select><br />

                                    <button type="submit" class="btn btn-success">Actualizar</button>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @php
        // $countExtraImages = count($experiencia->images->where('is_principal',false));
        $extraImages = array();

        foreach ($experiencia->images->where('is_principal',false) as $image) {
            $extraImages[] = array(
                'id' =>  $image->id,
                'src' => asset('storage/experiencias/'. $image->url_image)
            );
//            array_push($varJS, asset('storage/experiencias/'. $image->url_image));
        }
    @endphp
<script src="//js.nicedit.com/nicEdit-latest.js" type="text/javascript"></script>
<!--script type="text/javascript">bkLib.onDomLoaded(nicEditors.allTextAreas);</script-->
@endsection


@section('scripts')

<script type="text/javascript" src="{{ asset('js/image-uploader.js') }}"></script>

<script>

    let preloaded_extra_images = {!! json_encode( $extraImages) !!};

    let preloaded_main_image = [
        {id: 1, src: "{!! asset('storage/experiencias/'.$experiencia->picture)!!}"},
    ];
    $('.main_image').imageUploader({
        label: 'Arrastra o hace click para cargar la imagen principal',
        imagesInputName: 'main_image',
        preloaded: preloaded_main_image,
        maxSize: 4 * 1024 * 1024,
        maxFiles: 1,
        preloadedInputName: 'old_main_image',
    });

    $('.extra_images').imageUploader({
        label: 'Arrastra o hace click para cargar imagenes',
        imagesInputName: 'extra_images',
        preloaded: preloaded_extra_images,
        maxSize:4 * 1024 * 1024,
        preloadedInputName: 'old_extra_images',

    });

</script>


@endsection
