@extends('admin.layout.admin')
<head>
    <link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link type="text/css" rel="stylesheet" href="{{ asset('css/image-uploader.css') }}">
</head>
<style>
    .label-check{
        margin-right: 15px;
    }
</style>
@section('contenido')
    <div class="content-wrapper">
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h3 class="card-title">Nueva Experiencia</h3>
                        <div class="row">
                            <div class="col-12 form-group">
                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                <form action="{{ url('/nueva-experiencia') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <label for="title">Título <span class="danger">*</span> </label>
                                    <input type="text" name="title" placeholder="Título de la experiencia"
                                           class="form-control" required value="{{ old('title') }}"/><br />

                                    <label for="title">Título en ingles</label>
                                    <input type="text" name="title_en" placeholder="Título de la experiencia ingles" class="form-control"/><br />

                                    <label for="description">Descripción <span class="red">*</span></label>
                                    <textarea name="description" id="description" placeholder="Descipción de la experiencia" rows="10" cols="50" class="form-control"></textarea><br/>

                                    <label for="description">Descripción en ingles</label>
                                    <textarea name="description_en" id="description_en" placeholder="Descipción de la experiencia ingles" rows="10" cols="50" class="form-control"></textarea><br/>

                                    <label for="price">Precio <span class="red">*</span></label>
                                    <input type="number" min="0" name="price" step=".01" placeholder="Precio de la experiencia" class="form-control" required /><br />

                                    <label for="place">Ubicación <span class="red">*</span></label>
                                    <input type="text" name="place" placeholder="Ubicación de la experiencia" class="form-control" required /><br />

                                    <label for="city">Ciudad <span class="red">*</span></label>
                                    <input type="text" name="city" placeholder="Ciudad de la experiencia" class="form-control" required /><br />

                                    <label for="province">Provincia <span class="red">*</span></label>
                                    <input type="text" name="province" placeholder="Provincia de la experiencia" class="form-control" required /><br />

                                    <label for="coordenates">Coordenadas <span class="red">*</span></label>
                                    <input type="text" name="coordenates" placeholder="Coordenadas de la experiencia (xxxx,yyyy)" class="form-control" required /><br />

                                    <label for="main_page">Destacada <span class="red">*</span></label>
                                    <select name="main_page" id="" class="form-control">
                                        <option value="0" selected>No</option>
                                        <option value="1">Si</option>
                                    </select><br />

                                    <label for="hours">Horas <span class="red">*</span></label>
                                    <input type="text" name="hours" placeholder="Horas de duración" class="form-control" required /><br />

                                    <label for="includes">Incluye <span class="red">*</span></label>
                                    <input type="text" name="includes" placeholder="Que incluye la experiencia" class="form-control" required /><br />

                                    <p>Idiomas: <span class="red">*</span></p>
                                    <input type="checkbox" name="español" value="español" /> <label for="languajes" class="label-check">Español</label>
                                    <input type="checkbox" name="ingles" value="ingles" /> <label for="languajes" class="label-check">Inlges</label>
                                    <input type="checkbox" name="italiano" value="italiano" /> <label for="languajes" class="label-check">Italiano</label>
                                    <input type="checkbox" name="portugues" value="portugues" /> <label for="languajes" class="label-check">Portugues</label>
                                    <input type="checkbox" name="frances" value="frances" /> <label for="languajes" class="label-check">Frances</label>
                                    <input type="checkbox" name="aleman" value="aleman" /> <label for="languajes" class="label-check">Aleman</label>
                                    <br />

                                    <label for="must_learn_languaje">Turista: Necesita habla el idioma? <span class="red">*</span></label>
                                    <select name="must_learn_languaje" class="form-control">
                                        <option value="0" selected>No</option>
                                        <option value="1">Si</option>
                                    </select><br />

                                    <label for="what_bring">¿Qué llevar? <span class="red">*</span></label>
                                    <input type="text" name="what_bring" placeholder="Que se debe llevar a la experiencia" class="form-control" required /><br />

                                    <label for="extra_indications">Indicaciones extra <span class="red">*</span></label>
                                    <input type="text" name="extra_indications" placeholder="Por ej: A una cuadra de la ruta..." class="form-control" required /><br />

                                    <label for="reservations_phone">Teléfono (Reservas solamente) <span class="red">*</span></label>
                                    <input type="text" name="reservations_phone" placeholder="Teléfono solo para reservas" class="form-control" required /><br />

                                    <label for="more_about">Más datos sobre la Experiencia</label>
                                    <textarea name="more_about" rows="10" cols="50" class="form-control" placeholder="Por ej: servimos postres variados..."></textarea><br/>

                                    <label for="place_id">Lugar: <span class="red">*</span></label>
                                    <select name="place_id" class="form-control">
                                        <option value="0">Otro</option>
                                        @foreach($lugares as $lugar)
                                            <option value="{{ $lugar->id }}">{{ $lugar->name }}</option>
                                        @endforeach
                                    </select><br />

                                    <label for="user_id">Anfitrion: <span class="red">*</span></label>
                                    <select name="user_id" class="form-control">
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->user_details->fake_name }}</option>
                                        @endforeach
                                    </select><br />

                                    <label for="category">Categoria: <span class="red">*</span></label>
                                        @foreach($categorias as $categoria)
                                            <input type="checkbox" name="categorias[]" value="{{$categoria->id}}" /> <label for="categoria_{{$categoria->id}}" class="label-check">{{$categoria->title}}</label>
                                        @endforeach
                                    <br/>
                                    <br>
                                    <label style="background-color: yellow">Imagen principal (Max 2MB)</label>
                                    <input type="file" class="form-control" name="main_image" required />
                                    <!--div>
                                        <div class="imagen-principal" style="padding-top: .5rem;"></div>
                                    </div-->
                                    <br>

                                    <label for="picture">Imagenes extra</label>
                                        <div>
                                            <div class="extra_images" style="padding-top: .5rem;"></div>
                                        </div>
                                    <br>

                                    <label for="video">Video</label>
                                    <input type="text" name="video" class="form-control" id="video" placeholder="Ingrese el codigo aqui "/>
                                    <br>


                                    <label for="reservation">¿Utiliza el panel de reservas Yeah?</label>
                                    <select name="reservation" class="form-control" id="expePanel">
                                        <option value="0">No</option>
                                        <option value="1">Si</option>
                                    </select><br />

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div id="hoursDays" style="display: none;">
                                                <p>Idiomas:</p>
                                                <input type="checkbox" name="Lunes" value="Lunes" />
                                                <label for="Lunes" class="label-check">Lunes</label>
                                                <br />

                                                <input type="checkbox" name="Martes" value="Martes" />
                                                <label for="Martes" class="label-check">Martes</label>
                                                <br />

                                                <input type="checkbox" name="Miercoles" value="Miercoles" />
                                                <label for="Miercoles" class="label-check">Miercoles</label>
                                                <br />

                                                <input type="checkbox" name="Jueves" value="Jueves" />
                                                <label for="Jueves" class="label-check">Jueves</label>
                                                <br />

                                                <input type="checkbox" name="Viernes" value="Viernes" />
                                                <label for="Viernes" class="label-check">Viernes</label>
                                                <br />

                                                <input type="checkbox" name="Sabado" value="Sabado" />
                                                <label for="Sabado" class="label-check">Sabado</label>
                                                <br />

                                                <input type="checkbox" name="Domingo" value="Domingo" />
                                                <label for="Domingo" class="label-check">Domingo</label>
                                                <br />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div id="hoursOnly" style="display: none;">
                                                <label for="">Horas de inicio</label>
                                                <select name="hours_start" id="" class="form-control">
                                                    <option value="">00:00</option>
                                                    <option value="">01:00</option>
                                                    <option value="">02:00</option>
                                                    <option value="">03:00</option>
                                                    <option value="">04:00</option>
                                                    <option value="">05:00</option>
                                                    <option value="">06:00</option>
                                                    <option value="">07:00</option>
                                                    <option value="">08:00</option>
                                                    <option value="">09:00</option>
                                                    <option value="">10:00</option>
                                                    <option value="">11:00</option>
                                                    <option value="">12:00</option>
                                                    <option value="">13:00</option>
                                                    <option value="">14:00</option>
                                                    <option value="">15:00</option>
                                                    <option value="">16:00</option>
                                                    <option value="">17:00</option>
                                                    <option value="">18:00</option>
                                                    <option value="">19:00</option>
                                                    <option value="">20:00</option>
                                                    <option value="">21:00</option>
                                                    <option value="">22:00</option>
                                                    <option value="">23:00</option>
                                                </select>

                                                <br><br>
                                                <label for="">Horas de Finalización</label>
                                                <select name="hours_end" id="" class="form-control">
                                                    <option value="">00:00</option>
                                                    <option value="">01:00</option>
                                                    <option value="">02:00</option>
                                                    <option value="">03:00</option>
                                                    <option value="">04:00</option>
                                                    <option value="">05:00</option>
                                                    <option value="">06:00</option>
                                                    <option value="">07:00</option>
                                                    <option value="">08:00</option>
                                                    <option value="">09:00</option>
                                                    <option value="">10:00</option>
                                                    <option value="">11:00</option>
                                                    <option value="">12:00</option>
                                                    <option value="">13:00</option>
                                                    <option value="">14:00</option>
                                                    <option value="">15:00</option>
                                                    <option value="">16:00</option>
                                                    <option value="">17:00</option>
                                                    <option value="">18:00</option>
                                                    <option value="">19:00</option>
                                                    <option value="">20:00</option>
                                                    <option value="">21:00</option>
                                                    <option value="">22:00</option>
                                                    <option value="">23:00</option>
                                                </select>

                                                <br>
                                                <br>

                                                <label>Cantidad de lugares:</label>
                                                <input type="number" class="form-control" placeholder="Ingrese cantidad de lugares" name="amount_sales" />
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <br>
                                    <button type="submit" class="btn btn-success">Crear</button>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!--script src="//js.nicedit.com/nicEdit-latest.js" type="text/javascript"></script>
<script type="text/javascript">bkLib.onDomLoaded(nicEditors.allTextAreas);</script-->
@endsection
@section('scripts')

<script type="text/javascript" src="{{ asset('js/image-uploader.js') }}"></script>

<script>

$('.extra_images').imageUploader({
    label: 'Arrastra o hace click para cargar imagenes',
    imagesInputName: 'extra_images',
    maxSize:4 * 1024 * 1024,
});
$('.imagen-principal').imageUploader({
    label: 'Arrastra o hace click para cargar la imagen principal',
    imagesInputName: 'main_image',
    maxFiles:1,
    maxSize:4 * 1024 * 1024,
});


$('#expePanel').on('change', function() {
    if(this.value == 1){
        document.getElementById("hoursDays").style.display = "inline";
        document.getElementById("hoursOnly").style.display = "inline";
    }
    else{
        document.getElementById("hoursDays").style.display = "none";
        document.getElementById("hoursOnly").style.display = "none";
    }
});
</script>


@endsection
