<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
        <tr>
            <th>#</th>
            <th style="cursor: pointer" >Fecha Venta<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Comprador<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Título<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Anfitrion<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Precio(Pago)<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Precio(a facturar)<i class="ml-4 fas fa-caret-down"></i></th>
            <th>Fecha/Hora de la reserva</th>
            <th>Pendiente / Utilizada</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($reservas as $reserva)
        <tr>
            <td>
                <p>{{$reserva->id}}</p>
            </td>
            <td>
                <p>{{ \Carbon\Carbon::parse($reserva->created_at)->format('d-m-Y') }}</p>
            </td>
            <td>
                <p>{{$reserva->user->name}}</p>
            </td>
            <td>
                <p>{{ $reserva->experiencia->title }}</p>
            </td>
            <td>
                <p>{{ $reserva->experiencia->user->name }}</p>
            </td>
            <td>
                <p>$ {{ $reserva->experiencia->final_price }}</p>
            </td>
            <td>
                <p>$ {{ $reserva->experiencia->price }}</p>
            </td>
            <td>
                <p>{{ $reserva->reserva }}</p>
            </td>
            <td>
                <p>
                    @if(\Carbon\Carbon::today() > $reserva->reserva)
                        <strong style="color: #0f6674"> Realizada </strong>
                    @else <strong style="color: #761b18">Pendiente</strong>
                    @endif
                </p>
            </td>


        </tr>
        @empty
        <td >No hay registros para mostrar</td>
        @endforelse
    </tbody>
</table>
<div class="d-flex justify-content-center" style="padding-bottom: 10px;">
    {{ $reservas->links() }}
</div>
