<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
        <th>#</th>
        <th style="cursor: pointer" >Fecha Venta<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Codigo<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Título<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Anfitrion<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Precio<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Ciudad<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Dirección<i class="ml-4 fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Requiere reserva<i class="ml-4 fas fa-caret-down"></i></th>
        <th>Estado de la compra</th>
        <th>Pendiente / Utilizada</th>
        <th>Eliminar</th>
    </tr>
    </thead>
    <tbody>
    @forelse ($ventas as $venta)
        <tr>
            <td>
                <p>{{$venta->id}}</p>
            </td>
            <td>
                <p>{{$venta->created_at}}</p>
            </td>
            <td>
                <p>{{$venta->codigoCanjeable ? $venta->codigoCanjeable->code : 'Sin codigo'}}</p>
            </td>
            <td>
                <p>{{$venta->experiencia->title}}</p>
            </td>
            <td>
                <p>{{$venta->experiencia->user->name}}</p>
            </td>
            <td>
                <p>$ {{$venta->amount}}.00</p>
            </td>
            <td>
                <p>{{$venta->experiencia->city}}</p>
            </td>
            <td>
                <p>{{$venta->experiencia->place}}</p>
            </td>
            <td>
                <p>{{$venta->experiencia->reservation == 1 ? "Si" : "No"}}</p>
            </td>
            <td>
                <p>{{$venta->approved == 1 ? "Aprobada" : "Rechazada"}}</p>
            </td>
            <td>
                @if($venta->codigoCanjeable)
                    <p> {{$venta->codigoCanjeable->used == 1 ? "Utilizado" : "Pendiente de uso" }}</p>
                @else
                    -
                @endif
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form action="{{ route('venta.delete',$venta) }}" method="POST">
                        @csrf
                        <button style="border: none;background-color: transparent"><i style="color: gray" class="fa fa-trash"></i></button>
                    </form>
                </div>
            </td>
        </tr>
    @empty
        <td >No hay registros para mostrar</td>
    @endforelse
    </tbody>
</table>
<div class="d-flex justify-content-center" style="padding-bottom: 10px;">
    {{ $ventas->links() }}
</div>
