<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
        <th style="cursor: pointer" >#<i class="fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Experiencia</th>
        <th style="cursor: pointer" >Usuario/Retira</th>
        <th style="cursor: pointer" >Fecha de compra</th>
        <th style="cursor: pointer" >Código</th>
        <th style="cursor: pointer" >Retirado</th>
        <th style="cursor: pointer" >Marcar Retirado</th>
        <th style="cursor: pointer" >Borrar</th>
        
    </tr>
    </thead>
    <tbody>
    @foreach ($pickups as $pickup)
        <tr style="">
            <td>
                <p>{{$pickup->id}}</p>
            </td>
            </td>
            <td>
                <p>{{$pickup->experiencia->title}}</p>
            </td>
            <td>
                <p>{{$pickup->user->name}}</p>
            </td>
            <td>
                <p>{{$pickup->created_at}}</p>
            </td>
            <td>
                <p>{{$pickup->venta->code}}</p>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    @if ($pickup->retirado)
                        <i style="color: #4B49AC" class="fas fa-check" ></i>
                    @else
                        <i style="color: gray" class="fas fa-times"></i>
                    @endif
                </div>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form action="{{ url('/retiro-completado') }}" method="POST">
                        @csrf
                        <input type="number" name="id" style="display: none" value="{{ $pickup->id }}" id="" hidden />
                        <button type="submit" style="border: none;background-color: transparent">
                            <i class="fas fa-check-square"></i>
                        </button>
                    </form>
                </div>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form action="{{ route('pickup.delete',$pickup) }}" method="POST">
                        @csrf
                        <button style="border: none;background-color: transparent"><i style="color: gray" class="fa fa-trash"></i></button>
                    </form>
                </div>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
<div class="d-flex justify-content-center">
    {{$pickups->links() }}
</div>
