<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
            <th style="cursor: pointer" >#<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Nombre<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Cantidad de experiencias disponibles<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Imagen</th>
            <th style="cursor: pointer" >Estado<i class="ml-4 fas fa-caret-down"></i></th>
            <th style="cursor: pointer" >Dar de baja/Editar</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($lugares as $lugar)
        <tr style="text-align: center">
            <td>
                <p>{{$lugar->id}}</p>
            </td>
            <td>
                <p>{{$lugar->name}}</p>
            </td>
            <td>
                <p>{{count($lugar->experiencias)}}</p>
            </td>
            <td style="max-width: 150px">
                <img style="width: 100%;" src="{{ asset('storage/places') }}/{{$lugar->image }}">
            </td>
            <td>
                <p style="{{$lugar->status == 1 ? 'color:#4B49AC' : ''}}  ">
                @if ($lugar->status==1)
                Activo
                @elseif ($lugar->status==2)
                Pendiente de aprobacion
                @else
                Inactivo
                @endif
                </p>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <a href="{{ route('admin.places.edit',$lugar) }}">
                        <i style="color: #4B49AC" class="fas fa-pencil-alt"></i>
                    </a>
                    <form action="{{ route('place.softdelete',$lugar) }}" method="POST">
                        @csrf
                        <button style="border: none;background-color: transparent">
                            <i style="color: gray" class="fa fa-trash"></i>
                        </button>
                    </form>
                </div>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
<div class="d-flex justify-content-center">
    {{$lugares->links() }}
</div>
