<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
        <th style="cursor: pointer" >#<i class="fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Fecha</th>
        <th style="cursor: pointer" >Direccion<i class="fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Ciudad<i class="fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Provincia</th>
        <th style="cursor: pointer" >Experiencia</th>
        <th style="cursor: pointer" >Codigo</th>
        <th style="cursor: pointer" >Destinatario</th>
        <th style="cursor: pointer" >Enviado</th>
        <th style="cursor: pointer" >Marcar envio</th>
        <th style="cursor: pointer" >Borrar</th>
    </tr>
    </thead>
    <tbody>
        @forelse ($envios as $envio)
        <tr style="">
            <td>
                <p>{{$envio->id}}</p>
            </td>
            <td>
                <p>{{$envio->created_at}}</p>
            </td>
            <td>  
                <p>{{$envio->direccion}}</p>
            </td>
            <td>
                <p>{{$envio->ciudad}}</p>
            </td>
            <td>
                <p>{{$envio->provincia}}</p>
            </td>
            <td>
                <p>{{$envio->experiencia->title}}</p>
            </td>
            <td>
                <p>{{$envio->experiencia->codigos_canjeable->first() ? $envio->experiencia->codigos_canjeable->first()->code : 'Sin codigo'}}</p>
            </td>
            <td>
                <p>{{$envio->user->name}}</p>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    @if ($envio->enviado)
                        <i style="color: #4B49AC" class="fas fa-check" ></i>
                    @else
                        <i style="color: gray" class="fas fa-times"></i>
                    @endif
                </div>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form action="{{ url('/envio-completado') }}" method="POST">
                        @csrf
                        <input type="number" name="id" value="{{ $envio->id }}" style="display: none" hidden />
                        <button type="submit" style="border: none;background-color: transparent">
                            <i class="fas fa-check-square"></i>
                        </button>
                    </form>
                </div>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form action="{{ route('envio.delete',$envio) }}" method="POST">
                        @csrf
                        <button style="border: none;background-color: transparent"><i style="color: gray" class="fa fa-trash"></i></button>
                    </form>
                </div>
            </td>
        </tr>
        @empty
            <td >No hay registros para mostrar</td> 
        @endforelse
    </tbody>
</table>
<div class="d-flex justify-content-center">
    {{$envios->links() }}
</div>
