<table id="table_data" class="display expandable-table" style="width:100%">
    <thead>
    <tr>
        <th style="cursor: pointer" >#<i class="fas fa-caret-down"></i></th>
        <th style="cursor: pointer" >Codigo<i class="fas fa-caret-down"></i></th>
        <th style="cursor: pointer" > {{ isset($codigo_descuento) ? 'Nro. de veces usado' :  'Usado' }}<i class="fas fa-caret-down"></i></th>
        @isset($codigo_descuento)
            <th style="cursor: pointer" >Porcentaje de descuento<i class="fas fa-caret-down"></i></th>    
        @endisset
        <th style="cursor: pointer" >Experiencia</th>
        <th style="cursor: pointer" >Fecha de vencimiento</th>
        <th style="cursor: pointer" >Dar de baja</th>
    </tr>
    </thead>
    <tbody>
    @foreach ($codigos as $codigo)
    
        <tr style="">
            <td>
                <p>{{$codigo->id}}</p>
            </td>
            <td>
                <p>{{$codigo->code}}</p>
            </td>
            <td>
                <p>{{isset($codigo_descuento) ? count($codigo->users) : $codigo->used}}</p>
            </td>
            @isset($codigo_descuento)
            <td>
                <p>% {{$codigo->discount}}</p>
            </td>
            @endisset
            <td>
                <p>{{$codigo->experiencia != null ? $codigo->experiencia->title : (isset($codigo->apply_on_experiencia_id) ? $codigo->apply_on_experiencia_id :  'Todas') }}</p>
            </td>
            <td>
                <p>{{$codigo->date_exp}}</p>
            </td>
            <td>
                <div style="justify-content: space-around" class="row">
                    <form action="{{ route('codigo_delete') }}" method="POST">
                        @method('DELETE')
                        @csrf
                        @isset($codigo_descuento)
                            <input type="hidden" name="discount_code" value="x">
                        @endisset
                        <input type="hidden" name="id" value="{{ $codigo->id }}">
                        <button style="border: none;background-color: transparent">
                            <i style="color: gray" class="fa fa-trash"></i>
                        </button>
                    </form>
                </div>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
<div class="d-flex justify-content-center">
    {{$codigos->links() }}
</div>
